package com.dtyunxi.yundt.imkt.bundle.common.center.marketing.api.dto.request.task;

import com.dtyunxi.yundt.imkt.bundle.common.center.marketing.api.dto.request.TwoTuple;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.List;

@ApiModel("目标人群")
public class TargetThrongReqDto  implements Serializable {

    private static final long serialVersionUID = 8520964245015653962L;
    @ApiModelProperty(value = "0:所有会员 1：指定人群分组 2：指定等级，必填 3指定会籍")
    private int range;

    @ApiModelProperty(value = "目标人群分组id【range=1时必填，mk_groups_info表的remote_group_id，对应标签中心的标签分组id】")
    private Long groupId;

    @ApiModelProperty(value = "人群包id（range=1时必填，mk_groups_info表主键id）")
    private Long targetGroupsInfoId;

    @ApiModelProperty(value = "目标人群分组名，range=1时选填")
    private String groupName;

    @ApiModelProperty(value = "等级类型数组【first：等级id，second：等级名称】，range=2时必填")
    private List<TwoTuple<Long, String>> levels;

    @ApiModelProperty(value = "会籍类型数组【first：会籍id，second：会籍名称】，range=3时必填")
    private List<TwoTuple<Long, String>> memberShips;

    public List<TwoTuple<Long, String>> getMemberShips() {
        return memberShips;
    }

    public void setMemberShips(List<TwoTuple<Long, String>> memberShips) {
        this.memberShips = memberShips;
    }



    public List<TwoTuple<Long, String>> getLevels() {
        return levels;
    }

    public void setLevels(List<TwoTuple<Long, String>> levels) {
        this.levels = levels;
    }

    public int getRange() {
        return range;
    }

    public void setRange(int range) {
        this.range = range;
    }

    public Long getGroupId() {
        return groupId;
    }

    public void setGroupId(Long groupId) {
        this.groupId = groupId;
    }

    public Long getTargetGroupsInfoId() {
        return targetGroupsInfoId;
    }

    public void setTargetGroupsInfoId(Long targetGroupsInfoId) {
        this.targetGroupsInfoId = targetGroupsInfoId;
    }

    public String getGroupName() {
        return groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }
}
