package com.dtyunxi.yundt.imkt.bundle.common.center.marketing.api.dto.response;

import com.dtyunxi.yundt.imkt.bundle.common.center.marketing.api.constants.DtoApiNoteConstants;
import com.dtyunxi.yundt.imkt.bundle.common.center.marketing.api.constants.enums.MarketingTypeEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Date;

@ApiModel("营销任务摘要信息（列表使用）")
public class TaskAbstractRespDto {

    @ApiModelProperty("主动营销id")
    private Long id;

    @ApiModelProperty("主动营销名称")
    private String name;

    @ApiModelProperty(value = "营销任务编号")
    private String code;

    @ApiModelProperty("营销类型【" + DtoApiNoteConstants.MARKETING_TYPE+"】")
    private Integer marketingType = MarketingTypeEnum.MARKETING.getKey();

    @ApiModelProperty("任务类型码【0：仅通知 1：H5活动 2：优惠券】")
    private Integer type;

    @ApiModelProperty("状态码【"+ DtoApiNoteConstants.TASK_STATUS+"】")
    private Integer status;

    @ApiModelProperty("更新时间")
    private Date updateTime;

    @ApiModelProperty("创建时间")
    private Date createTime;

    @ApiModelProperty("更新账号")
    private String updateAccount;

    @ApiModelProperty("启用账号")
    private String enableAccount;

    @ApiModelProperty("活动ID")
    private Long activityId;
    @ApiModelProperty("默认0 普通优惠券 1个性化优惠券 ")
    private int personalizeCouponType;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public Date getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public String getEnableAccount() {
        return enableAccount;
    }

    public void setEnableAccount(String enableAccount) {
        this.enableAccount = enableAccount;
    }

    public Integer getMarketingType() {
        return marketingType;
    }

    public void setMarketingType(Integer marketingType) {
        this.marketingType = marketingType;
    }

    public String getUpdateAccount() {
        return updateAccount;
    }

    public void setUpdateAccount(String updateAccount) {
        this.updateAccount = updateAccount;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Long getActivityId() {
        return activityId;
    }

    public void setActivityId(Long activityId) {
        this.activityId = activityId;
    }

    public int getPersonalizeCouponType() {
        return personalizeCouponType;
    }

    public void setPersonalizeCouponType(int personalizeCouponType) {
        this.personalizeCouponType = personalizeCouponType;
    }
}
