package com.dtyunxi.yundt.imkt.bundle.common.center.marketing.api.dto.response;

import com.dtyunxi.vo.BaseVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Date;

/**
 * 主动营销数据表原生数据，无任何添加剂，请放心使用
 * @author : 萧玄
 * @Date: 10:50 2019/8/16
 */
@ApiModel("主动营销数据表原生数据，无任何添加剂，请放心使用")
public class TaskRespDto extends BaseVo {

    @ApiModelProperty("id")
    protected Long id;


    @ApiModelProperty("名称")
    private String name;

    @ApiModelProperty("任务编号(ZD字符+id)")
    private String code;

    @ApiModelProperty("不受营销限制(0：受,默认值 1：不受)")
    private Integer notLimit;

    @ApiModelProperty("类型（0仅通知 1活动 2优惠券）")
    private Integer type;

    @ApiModelProperty("优惠券推送方式(0：定向推券 1：领券中心-通用 2：领券中心-精准)")
    private Integer couponPushMethod;

    @ApiModelProperty("活动id(type=1时必填)")
    private Long activityId;

    @ApiModelProperty("活动名称成(type=1时必填)")
    private String activityName;

    @ApiModelProperty("活动开始时间(type=1时必填)")
    private Date activityBeginTime;

    @ApiModelProperty("状态（0待启用 1待执行 2已禁用 3执行中 4已完成）")
    private Date activityEndTime;

    @ApiModelProperty("状态（0待启用 1待执行 2已禁用 3执行中 4已完成）")
    private Integer status;

    @ApiModelProperty("是否已生成执行数据标记（0未执行 1已执行 2等待下一次处理）")
    private Integer createExecData;

    @ApiModelProperty("目标人群范围（0:所有会员 1：指定人群 2：指定等级）")
    private Integer targetRange;

    @ApiModelProperty("目标人群分组id（range=1时必填，mk_groups_info表的remote_group_id）")
    private Long targetGroupId;

    @ApiModelProperty("人群包id（range=1时必填，mk_groups_info表主键）")
    private Long targetGroupsInfoId;

    @ApiModelProperty("目标人群分组名称（range=1时必填）")
    private String targetGroupName;

    @ApiModelProperty("推送日期（格式：yyyy-MM-dd，time_type=0/3/4必填）")
    private String pushDate;

    @ApiModelProperty("推送时间点(格式HH:mm或者HH:mm:ss）")
    private String pushTime;

    @ApiModelProperty("活动开始前X天/活动结束前X天")
    private Integer subDay;

    @ApiModelProperty("时间类型(0：指定时间 1：活动开始前 2：活动结束前 3：每7天循环 4：每月固定第几号循环)")
    private Integer timeType;

    @ApiModelProperty("每月的几号（time_type=4时候，循环规则选择为每月的时候填写；其余留空）")
    private Integer dayNo;

    @ApiModelProperty("首次执行时间(必填)")
    private Date firstTriggerTime;

    @ApiModelProperty("终止执行时间")
    private Date endTriggerTime;

    @ApiModelProperty("调度任务id（sc_task表主键）")
    private Long scTaskId;

    @ApiModelProperty("更新账号")
    private String updateAccount;

    @ApiModelProperty("启用账号")
    private String enableAccount;

    @ApiModelProperty("组织部门id")
    private Long orgId;

    @ApiModelProperty("扩展字段")
    private String extension;

    @ApiModelProperty("租户id")
    protected Long tenantId;

    @ApiModelProperty("实例id")
    protected Long instanceId;

    @ApiModelProperty("创建人")
    protected String createPerson;

    @ApiModelProperty("创建时间")
    protected Date createTime;

    @ApiModelProperty("更新人")
    protected String updatePerson;

    @ApiModelProperty("更新时间")
    protected Date updateTime;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public Integer getNotLimit() {
        return notLimit;
    }

    public void setNotLimit(Integer notLimit) {
        this.notLimit = notLimit;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public Integer getCouponPushMethod() {
        return couponPushMethod;
    }

    public void setCouponPushMethod(Integer couponPushMethod) {
        this.couponPushMethod = couponPushMethod;
    }

    public Long getActivityId() {
        return activityId;
    }

    public void setActivityId(Long activityId) {
        this.activityId = activityId;
    }

    public String getActivityName() {
        return activityName;
    }

    public void setActivityName(String activityName) {
        this.activityName = activityName;
    }

    public Date getActivityBeginTime() {
        return activityBeginTime;
    }

    public void setActivityBeginTime(Date activityBeginTime) {
        this.activityBeginTime = activityBeginTime;
    }

    public Date getActivityEndTime() {
        return activityEndTime;
    }

    public void setActivityEndTime(Date activityEndTime) {
        this.activityEndTime = activityEndTime;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public Integer getCreateExecData() {
        return createExecData;
    }

    public void setCreateExecData(Integer createExecData) {
        this.createExecData = createExecData;
    }

    public Integer getTargetRange() {
        return targetRange;
    }

    public void setTargetRange(Integer targetRange) {
        this.targetRange = targetRange;
    }

    public Long getTargetGroupId() {
        return targetGroupId;
    }

    public void setTargetGroupId(Long targetGroupId) {
        this.targetGroupId = targetGroupId;
    }

    public Long getTargetGroupsInfoId() {
        return targetGroupsInfoId;
    }

    public void setTargetGroupsInfoId(Long targetGroupsInfoId) {
        this.targetGroupsInfoId = targetGroupsInfoId;
    }

    public String getTargetGroupName() {
        return targetGroupName;
    }

    public void setTargetGroupName(String targetGroupName) {
        this.targetGroupName = targetGroupName;
    }

    public String getPushDate() {
        return pushDate;
    }

    public void setPushDate(String pushDate) {
        this.pushDate = pushDate;
    }

    public String getPushTime() {
        return pushTime;
    }

    public void setPushTime(String pushTime) {
        this.pushTime = pushTime;
    }

    public Integer getSubDay() {
        return subDay;
    }

    public void setSubDay(Integer subDay) {
        this.subDay = subDay;
    }

    public Integer getTimeType() {
        return timeType;
    }

    public void setTimeType(Integer timeType) {
        this.timeType = timeType;
    }

    public Integer getDayNo() {
        return dayNo;
    }

    public void setDayNo(Integer dayNo) {
        this.dayNo = dayNo;
    }

    public Date getFirstTriggerTime() {
        return firstTriggerTime;
    }

    public void setFirstTriggerTime(Date firstTriggerTime) {
        this.firstTriggerTime = firstTriggerTime;
    }

    public Date getEndTriggerTime() {
        return endTriggerTime;
    }

    public void setEndTriggerTime(Date endTriggerTime) {
        this.endTriggerTime = endTriggerTime;
    }

    public Long getScTaskId() {
        return scTaskId;
    }

    public void setScTaskId(Long scTaskId) {
        this.scTaskId = scTaskId;
    }

    public String getUpdateAccount() {
        return updateAccount;
    }

    public void setUpdateAccount(String updateAccount) {
        this.updateAccount = updateAccount;
    }

    public String getEnableAccount() {
        return enableAccount;
    }

    public void setEnableAccount(String enableAccount) {
        this.enableAccount = enableAccount;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getExtension() {
        return extension;
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }

    public Long getTenantId() {
        return tenantId;
    }

    public void setTenantId(Long tenantId) {
        this.tenantId = tenantId;
    }

    public Long getInstanceId() {
        return instanceId;
    }

    public void setInstanceId(Long instanceId) {
        this.instanceId = instanceId;
    }

    public String getCreatePerson() {
        return createPerson;
    }

    public void setCreatePerson(String createPerson) {
        this.createPerson = createPerson;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public String getUpdatePerson() {
        return updatePerson;
    }

    public void setUpdatePerson(String updatePerson) {
        this.updatePerson = updatePerson;
    }

    public Date getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }
}