package com.dtyunxi.yundt.imkt.bundle.common.center.marketing.api.dto.response.event;

import com.dtyunxi.yundt.imkt.bundle.common.center.marketing.api.constants.DtoApiNoteConstants;
import com.dtyunxi.yundt.imkt.bundle.common.center.marketing.api.dto.MarketingCouponRespDto;
import com.dtyunxi.yundt.imkt.bundle.common.center.marketing.api.dto.request.TwoTuple;
import com.dtyunxi.yundt.imkt.bundle.common.center.marketing.api.dto.request.event.EventMarketingReqDto;
import com.dtyunxi.yundt.imkt.bundle.common.center.marketing.api.dto.request.task.RightsDefineDto;
import com.dtyunxi.yundt.imkt.bundle.common.center.marketing.api.dto.response.task.MarketingDto;
import com.dtyunxi.yundt.imkt.bundle.common.center.marketing.api.service.IMarketing;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.Valid;
import java.util.Date;
import java.util.List;

/**
 *
 * 事件营销返回参数
 * @author : 萧玄
 * @Date: 16:54 2019/7/4
 */
@ApiModel(value = "EventMarketingRespDto", description = "事件营销返回参数")
public class EventMarketingRespDto extends MarketingDto implements IMarketing {

    @ApiModelProperty(value = "营销id")
    private Long id;

    @ApiModelProperty(value = "营销名称")
    private String name;

    @ApiModelProperty(value = "状态【"+ DtoApiNoteConstants.EVENT_STATUS+"】")
    private Integer status;

    @ApiModelProperty(value = "更新账号")
    private String updateAccount;

    @ApiModelProperty(value = "更新时间")
    private Date updateTime;

    @ApiModelProperty("不受营销限制【true:不受营销限制 false:受营销限制（默认）】")
    private boolean notLimit;

    @ApiModelProperty("是否被限制服务限制 0否 1是")
    private Integer isBeLimit;

    @Valid
    @ApiModelProperty("适用店铺范围")
    private EventMarketingReqDto.ApplyShop applyShop;

    @ApiModelProperty("赠送的优惠券组【first:优惠券模板id,second赠送数量】")
    private List<TwoTuple<Long,Integer>> coupons;

    @ApiModelProperty("赠送的优惠券组：事件营销触发时使用")
    private List<MarketingCouponRespDto> giveCoupons;

    @ApiModelProperty("赠送的权益信息：事件营销触发时使用")
    private List<RightsDefineDto> rights;

    @ApiModelProperty("赠送积分数量")
    private Integer presentPoint;

    @ApiModelProperty("权重，默认0")
    private Integer weight = 0;

    @ApiModelProperty("有效时间类型（默认 0：永久 1：指定时间范围）")
    private Integer validTimeType = 0;

    @ApiModelProperty("截止有效时间")
    private Date endValidTime;

    @ApiModelProperty("初始有效时间")
    private Date firstValidTime;

    @ApiModelProperty("事件信息")
    private EventMarketingReqDto.SelectEvent event;
    @ApiModelProperty("事件规则信息")
    private EventRuleRespDto eventRuleRespDto;

    @ApiModelProperty(name = "scene", value = "发券场景：1进店有礼，2下单有礼")
    private Integer scene;

    @ApiModelProperty(name = "theme", value = "主题")
    private String theme;

    @ApiModelProperty(name = "memberShipIds", value = "权益发放使用--会籍ids")
    private List<Long> memberShipIds;

    @ApiModelProperty(name = "marketingTaskSource", value = "营销任务来源 (0 事件营销引擎 1发券宝 )")
    private Integer marketingTaskSource;

    public Integer getMarketingTaskSource() {
        return marketingTaskSource;
    }

    public void setMarketingTaskSource(Integer marketingTaskSource) {
        this.marketingTaskSource = marketingTaskSource;
    }

    @ApiModelProperty(name = "everyoneDailyLimit", value = "每人每天限制次数")
    private Integer everyoneDailyLimit;

    @ApiModelProperty(name = "everyoneTotalLimit", value = "每人总限制次数")
    private Integer everyoneTotalLimit;

    public List<RightsDefineDto> getRights() {
        return rights;
    }

    public void setRights(List<RightsDefineDto> rights) {
        this.rights = rights;
    }

    public List<Long> getMemberShipIds() {
        return memberShipIds;
    }

    public void setMemberShipIds(List<Long> memberShipIds) {
        this.memberShipIds = memberShipIds;
    }

    public Integer getIsBeLimit() {
        return isBeLimit;
    }

    public void setIsBeLimit(Integer isBeLimit) {
        this.isBeLimit = isBeLimit;
    }

    public Integer getEveryoneDailyLimit() {
        return everyoneDailyLimit;
    }

    public void setEveryoneDailyLimit(Integer everyoneDailyLimit) {
        this.everyoneDailyLimit = everyoneDailyLimit;
    }

    public Integer getEveryoneTotalLimit() {
        return everyoneTotalLimit;
    }

    public void setEveryoneTotalLimit(Integer everyoneTotalLimit) {
        this.everyoneTotalLimit = everyoneTotalLimit;
    }

    public Integer getScene() {
        return scene;
    }

    public void setScene(Integer scene) {
        this.scene = scene;
    }

    public String getTheme() {
        return theme;
    }

    public void setTheme(String theme) {
        this.theme = theme;
    }

    public EventRuleRespDto getEventRuleRespDto() {
        return eventRuleRespDto;
    }

    public void setEventRuleRespDto(EventRuleRespDto eventRuleRespDto) {
        this.eventRuleRespDto = eventRuleRespDto;
    }

    public EventMarketingReqDto.SelectEvent getEvent() {
        return event;
    }

    public void setEvent(EventMarketingReqDto.SelectEvent event) {
        this.event = event;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public String getUpdateAccount() {
        return updateAccount;
    }

    public void setUpdateAccount(String updateAccount) {
        this.updateAccount = updateAccount;
    }

    public Date getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public boolean isNotLimit() {
        return notLimit;
    }

    public void setNotLimit(boolean notLimit) {
        this.notLimit = notLimit;
    }

    public EventMarketingReqDto.ApplyShop getApplyShop() {
        return applyShop;
    }

    public void setApplyShop(EventMarketingReqDto.ApplyShop applyShop) {
        this.applyShop = applyShop;
    }

    public List<TwoTuple<Long, Integer>> getCoupons() {
        return coupons;
    }

    public void setCoupons(List<TwoTuple<Long, Integer>> coupons) {
        this.coupons = coupons;
    }

    public Integer getPresentPoint() {
        return presentPoint;
    }

    public void setPresentPoint(Integer presentPoint) {
        this.presentPoint = presentPoint;
    }

    public Integer getWeight() {
        return weight;
    }

    public void setWeight(Integer weight) {
        this.weight = weight;
    }

    public Integer getValidTimeType() {
        return validTimeType;
    }

    public void setValidTimeType(Integer validTimeType) {
        this.validTimeType = validTimeType;
    }

    public Date getEndValidTime() {
        return endValidTime;
    }

    public void setEndValidTime(Date endValidTime) {
        this.endValidTime = endValidTime;
    }

    public Date getFirstValidTime() {
        return firstValidTime;
    }

    public void setFirstValidTime(Date firstValidTime) {
        this.firstValidTime = firstValidTime;
    }

    public List<MarketingCouponRespDto> getGiveCoupons() {
        return giveCoupons;
    }

    public void setGiveCoupons(List<MarketingCouponRespDto> giveCoupons) {
        this.giveCoupons = giveCoupons;
    }
}
