package com.dtyunxi.yundt.imkt.bundle.common.center.marketing.api.enums;

import com.dtyunxi.cube.biz.commons.enums.IEnum;

/**
 * 范围类型 0：所有店铺（默认） 1：线上所有店铺 2：线下所有店铺 3：部分店铺 4：排除部分店铺
 * @author : 萧玄
 * @Date   : 16:45 2019/5/24
 */
public enum ApplyShopTypeEnum implements IEnum {

    ALL(0, "所有店铺"),
    ONLINE(1, "线上所有店铺"),
    OFFLINE(2, "线下所有店铺"),
    PART(3, "部分店铺"),
    EXCLUDE_PART(4, "排除部分店铺"),
    ;

    private int key;

    private String value;

    ApplyShopTypeEnum(int key, String value) {
        this.key = key;
        this.value = value;
    }

    @Override
    public int getKey() {
        return key;
    }

    public void setKey(int key) {
        this.key = key;
    }

    @Override
    public String getValue() {
        return value;
    }

    public void setValue(String value) {
        this.value = value;
    }
}
