package com.dtyunxi.yundt.imkt.bundle.common.center.marketing.api.enums;


import com.dtyunxi.cube.biz.commons.enums.IEnum;

/**
 * 事件类型：0：基础事件 1：等级事件 2：权益事件 3：积分事件 4：卡事件 5：券事件  6：标签事件 7:服务提醒事件 8: 实时标签事件
 * @author : 萧玄
 * @Date: 16:23 2019/6/19
 */
public enum EventTypeEnum implements IEnum {

    BASICS(0, "基础事件"),
    LEVEL(1, "等级事件"),
    RIGHT(2, "权益事件"),
    POINT(3, "积分事件"),
    CARD(4, "卡事件"),
    COUPON(5, "券事件"),
    LABEL(6, "标签事件"),
    SERVICE_ALERT(7, "服务提醒事件"),
    REAL_TIME_TAG(8, "实时标签事件"),
    WECHAT(9, "微信事件"),
    ;

    private int key;

    private String value;

    EventTypeEnum(int key, String value) {
        this.key = key;
        this.value = value;
    }

    @Override
    public int getKey() {
        return key;
    }

    public void setKey(int key) {
        this.key = key;
    }

    @Override
    public String getValue() {
        return value;
    }

    public void setValue(String value) {
        this.value = value;
    }
}
