package com.dtyunxi.yundt.imkt.bundle.common.center.marketing.api.enums;


import com.dtyunxi.cube.biz.commons.enums.IEnum;

/**
 * 主动营销当期循环的预备数据生成完毕枚举：0:未完成 1:已完成
 * @author : 萧玄
 * @Date: 16:23 2019/6/19
 */
public enum MarketingTaskFinishEnum implements IEnum {

    UN_FINISH(0, "未完成"),
    FINISHED(1, "已完成"),
    ;

    private int key;

    private String value;

    MarketingTaskFinishEnum(int key, String value) {
        this.key = key;
        this.value = value;
    }

    @Override
    public int getKey() {
        return key;
    }

    public void setKey(int key) {
        this.key = key;
    }

    @Override
    public String getValue() {
        return value;
    }

    public void setValue(String value) {
        this.value = value;
    }
}
