package com.dtyunxi.yundt.imkt.bundle.common.center.marketing.api.enums;

import com.dtyunxi.cube.biz.commons.enums.IEnum;

/**
 * 目标人群范围（0:所有会员 1：指定人群分组 2：指定等级）
 * @author : 萧玄
 * @Date   : 16:45 2019/5/24
 */
public enum ThrongRangeEnum implements IEnum {

    ALL(0, "所有会员"),
    GROUP(1, "指定人群分组"),
    LEVEL(2, "指定等级"),
    SHIP(3, "指定会籍"),
    ;
    private int key;

    private String value;

    ThrongRangeEnum(int key, String value) {
        this.key = key;
        this.value = value;
    }

    @Override
    public int getKey() {
        return key;
    }

    public void setKey(int key) {
        this.key = key;
    }

    @Override
    public String getValue() {
        return value;
    }

    public void setValue(String value) {
        this.value = value;
    }
}
