package com.dtyunxi.yundt.imkt.bundle.common.center.marketing.api.enums.mkt;

import com.dtyunxi.cube.biz.commons.enums.IEnum;

/**
 * 营销任务不受营销限制(0：受 1：不受)
 * @author : 萧玄
 * @Date: 16:23 2019/6/19
 */
public enum MarketingTaskNotLimitEnum implements IEnum {

    UN_LIMITED(0, "不受营销限制"),
    LIMITED(1, "受营销限制"),
    ;

    private int key;

    private String value;

    MarketingTaskNotLimitEnum(int key, String value) {
        this.key = key;
        this.value = value;
    }

    @Override
    public int getKey() {
        return key;
    }

    public void setKey(int key) {
        this.key = key;
    }

    @Override
    public String getValue() {
        return value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public static Integer getKey(boolean isNotLimit){
        return isNotLimit? MarketingTaskNotLimitEnum.UN_LIMITED.getKey(): MarketingTaskNotLimitEnum.LIMITED.getKey();
    }

    public static boolean getBoolean(int notLimit){
        return MarketingTaskNotLimitEnum.UN_LIMITED.isEqual(notLimit)?true:false;
    }
}
