package com.dtyunxi.yundt.imkt.bundle.common.center.marketing.api.enums.tag;

import org.apache.commons.lang3.StringUtils;

/**
 * 标签操作符枚举
 */
public enum TagOperatorEnum {

    AND("and", "与运算"),

    OR("or", "或运算");

    private String code;

    private String desc;

    public static TagOperatorEnum getByCode(String code) {
        if (StringUtils.isEmpty(code)) {
            return null;
        }
        for (TagOperatorEnum tagTypeEnum : TagOperatorEnum.values()) {
            if (code.equals(tagTypeEnum.getCode())) {
                return tagTypeEnum;
            }
        }

        return null;
    }

    TagOperatorEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
