package com.dtyunxi.yundt.imkt.bundle.common.center.marketing.api.enums.tag;

import org.apache.commons.lang3.StringUtils;

/**
 * 标签更新周期枚举
 */
public enum TagRefreshCycleEnum {

    ONLY_ONCE("1", "只执行一次"),
    EVERY_DAT("2", "每天"),
    EVERY_HOUR("3", "每月"),
    WEEK("4", "每星期"),
    YEAR("5", "每年");

    private String code;

    private String desc;

    public static TagRefreshCycleEnum getByCode(String code) {
        if (StringUtils.isEmpty(code)) {
            return null;
        }
        for (TagRefreshCycleEnum tagTypeEnum : TagRefreshCycleEnum.values()) {
            if (code.equals(tagTypeEnum.getCode())) {
                return tagTypeEnum;
            }
        }

        return null;
    }

    TagRefreshCycleEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
