package com.dtyunxi.yundt.imkt.bundle.common.center.marketing.api.exception;

import com.dtyunxi.yundt.imkt.bundle.common.center.marketing.api.constants.MarketingConstants;

/**
 * 业务异常错误码
 *
 * @author : 萧玄
 * @Date : 15:43 2019/6/19
 */
public enum MarketingBizExceptionCodeEnum implements IExceptionEnum {

    //系统异常
    OUTER_API_EXCEPTION(String.format("%s00000", MarketingConstants.CENTER_PRE_CODE), "外部接口调用异常"),

    //营销任务（主动营销）
    TASK_NAME_NULL(String.format("%s00001", MarketingConstants.CENTER_PRE_CODE), "名称不能为空"),
    TASK_NAME_TOO_LONG(String.format("%s00002", MarketingConstants.CENTER_PRE_CODE), "名称超长"),

    TASK_ACTIVITY_NULL(String.format("%s00003", MarketingConstants.CENTER_PRE_CODE), "活动不能为空"),
    TASK_COUPON_NULL(String.format("%s00004", MarketingConstants.CENTER_PRE_CODE), "优惠券不能为空"),
    TARGET_THRONG_NULL(String.format("%s00005", MarketingConstants.CENTER_PRE_CODE), "目标人群不能为空"),

    PUSH_TIME_NULL(String.format("%s00006", MarketingConstants.CENTER_PRE_CODE), "推送时间点不能为空"),
    PUSH_DATE_NULL(String.format("%s00007", MarketingConstants.CENTER_PRE_CODE), "推送日期不能为空"),
    PUSH_TIME_BEFORE_CURRENT(String.format("%s00008", MarketingConstants.CENTER_PRE_CODE), "推送时间不能小于当前时间"),

    PUSH_CHANNEL_NOT_EXISTED(String.format("%s00009", MarketingConstants.CENTER_PRE_CODE), "推送渠道不存在"),
    MSG_TEMPLATE_NULL(String.format("%s00010", MarketingConstants.CENTER_PRE_CODE), "消息模板不能为空"),
    MSG_TEMPLATE_TOO_LONG(String.format("%s00011", MarketingConstants.CENTER_PRE_CODE), "消息模板超长"),
    DAY_NO_ERROR(String.format("%s00012", MarketingConstants.CENTER_PRE_CODE), "每月最小1号最大31号"),

    TASK_ID_NULL(String.format("%s00013", MarketingConstants.CENTER_PRE_CODE), "主动营销id不能为空"),
    ONLY_CAN_DELTE_WHEN_TASK_WAITING_ENABLE(String.format("%s00014", MarketingConstants.CENTER_PRE_CODE), "只能删除待启用的主动营销"),
    TASK_NOT_EXISTED(String.format("%s00015", MarketingConstants.CENTER_PRE_CODE), "主动营销不存在"),
    TASK_INFO_ERROR(String.format("%s00016", MarketingConstants.CENTER_PRE_CODE), "主动营销[%s],配置异常，请修改配置后重新操作"),
    ONLY_CAN_EDIT_WHEN_TASK_WAITING_ENABLE(String.format("%s00017", MarketingConstants.CENTER_PRE_CODE), String.format("只能编辑%s的主动营销", "待启用")),

    NAME_CONFLICT(String.format("%s00018", MarketingConstants.CENTER_PRE_CODE), "名称重复"),
    END_TRIGGER_TIME_NULL(String.format("%s000019", MarketingConstants.CENTER_PRE_CODE), "执行终止时间不能为空"),
    ACTIVITY_BEGIN_TIME_NULL(String.format("%s00020", MarketingConstants.CENTER_PRE_CODE), "活动开始时间不能为空"),
    ACTIVITY_END_TIME_NULL(String.format("%s00021", MarketingConstants.CENTER_PRE_CODE), "活动结束时间不能为空"),
    CIRCLE_DAY_NO_NULL(String.format("%s00022", MarketingConstants.CENTER_PRE_CODE), "请填写每月固定第几号执行循环"),
    BEFORE_ACTIVITY_BEGIN_DAY_SUB_NULL(String.format("%s00023", MarketingConstants.CENTER_PRE_CODE), "请填写活动开始前几天执行"),
    BEFORE_ACTIVITY_END_DAY_SUB_NULL(String.format("%s00024", MarketingConstants.CENTER_PRE_CODE), "请填写活动结束前几天执行"),
    ONLY_CAN_DISABLE_WHEN_TASK_WAITING_EXECUTION_AND_EXECUTING(String.format("%s00025", MarketingConstants.CENTER_PRE_CODE), "只能禁用待执行、执行中的主动营销"),
    ONLY_CAN_ENABLE_WHEN_TASK_WAITING_ENABLE(String.format("%s00026", MarketingConstants.CENTER_PRE_CODE), "只能启用待启用的主动营销"),
    TEMPLATE_CODE_NULL(String.format("%s00027", MarketingConstants.CENTER_PRE_CODE), "选择微信、支付宝消息模板时供应商提供的模板编码不能为空"),
    TASK_EXPIRED(String.format("%s00028", MarketingConstants.CENTER_PRE_CODE), "此任务已过期"),
    TASK_PRE_DATA_LOCK_ERROR(String.format("%s00029", MarketingConstants.CENTER_PRE_CODE), "检测当期循环内是否已经完全生成预备数据方法异常，获取不到分布式锁"),
    TASK_ACTIVITY_URL_NULL(String.format("%s00030", MarketingConstants.CENTER_PRE_CODE), "活动链接不能为空"),

    //事件营销
    EVENT_MKT_ID_NULL(String.format("%s01000", MarketingConstants.CENTER_PRE_CODE), "事件营销id不能为空"),
    POINT_COST_NULL(String.format("%s01001", MarketingConstants.CENTER_PRE_CODE), "涉及的积分值不能为空"),
    POINT_RULE_ID_NULL(String.format("%s01002", MarketingConstants.CENTER_PRE_CODE), "积分规则id不能为空"),
    RIGHT_RULE_ID_NULL(String.format("%s01003", MarketingConstants.CENTER_PRE_CODE), "权益规则id不能为空"),
    RECENTLY_TOTAL_COST_NULL(String.format("%s01004", MarketingConstants.CENTER_PRE_CODE), "近365天累计消费总额不能为空"),
    COUPON_ID_NULL(String.format("%s01005", MarketingConstants.CENTER_PRE_CODE), "优惠券id不能为空"),
    LABEL_ID_NULL(String.format("%s01006", MarketingConstants.CENTER_PRE_CODE), "标签id不能为空"),
    TARGET_CUSTOMER_NULL(String.format("%s01007", MarketingConstants.CENTER_PRE_CODE), "目标客户不能为空"),
    PUSH_CHANNEL_NOT_EXIST(String.format("%s01008", MarketingConstants.CENTER_PRE_CODE), "推送渠道不存在"),
    EVNET_MARKETING_NOT_EXIST(String.format("%s01008", MarketingConstants.CENTER_PRE_CODE), "事件营销不存在"),
    TRIGGER_SHOP_NULL(String.format("%s01009", MarketingConstants.CENTER_PRE_CODE), "店铺不能为空"),
    AFTER_LEVEL_UP_ID_NULL(String.format("%s01010", MarketingConstants.CENTER_PRE_CODE), "升级后的等级id不能为空"),
    EVENT_CODE_DISMATCH_WITH_EVENT_TYPE(String.format("%s01011", MarketingConstants.CENTER_PRE_CODE), "事件码和对应的事件类型不匹配"),
    WEIGHT_CONFLICT_UNDER_EVENT_CODE(String.format("%s01012", MarketingConstants.CENTER_PRE_CODE), "同一个事件下的事件营销权重值必须唯一"),
    ONLY_CAN_DISABLE_WHEN_ENABLE(String.format("%s01013", MarketingConstants.CENTER_PRE_CODE), "只能禁用执行中的事件营销"),
    ONLY_CAN_DELTE_WAITING_ENABLE_EVENT_MKT(String.format("%s01014", MarketingConstants.CENTER_PRE_CODE), "只能删除待启用的事件营销"),
    EVENT_MKT_REFERENCED_BY_RIGHT(String.format("%s01015", MarketingConstants.CENTER_PRE_CODE), "事件营销已被权益引用"),
    ONLY_CAN_EDIT_WHEN_WAITING_ENABLE(String.format("%s01016", MarketingConstants.CENTER_PRE_CODE), "只能编辑待启用的事件营销"),
    ONLY_CAN_ENABLE_WHEN_WAITING_ENABLE(String.format("%s01017", MarketingConstants.CENTER_PRE_CODE), "只有待启用、已禁用状态的事件才可以启用"),
    EVENT_CODE_MULTIPLE_CONFIG_MARKETING(String.format("%s01018", MarketingConstants.CENTER_PRE_CODE), "该事件只能配置一个营销，不能重复"),
    EX_COUPON_NOT_SUPPORT_1(String.format("%s01019", MarketingConstants.CENTER_PRE_CODE), "券过期不支持配置触发时执行的营销"),
    EX_COUPON_NOT_SUPPORT_2(String.format("%s01020", MarketingConstants.CENTER_PRE_CODE), "券过期不支持配置触发前后0天的营销"),
    SUB_DAY_CANNOT_NEGATIVE(String.format("%s01021", MarketingConstants.CENTER_PRE_CODE), "触发天数差值不能为负数"),

    //事件管理
    CANNOT_DELETE_SYSTEM_EVENT(String.format("%s03000", MarketingConstants.CENTER_PRE_CODE), "不能删除系统事件"),
    EVENT_TYPE_NULL(String.format("%s03001", MarketingConstants.CENTER_PRE_CODE), "事件类型不能为空"),
    EVENT_NAME_NULL(String.format("%s03002", MarketingConstants.CENTER_PRE_CODE), "事件名称不能为空"),
    EVENT_CODE_NULL(String.format("%s03003", MarketingConstants.CENTER_PRE_CODE), "事件代码不能为空"),
    EVENT_ID_NULL(String.format("%s03004", MarketingConstants.CENTER_PRE_CODE), "事件id不能为空"),
    EVENT_NOT_EXISTS(String.format("%s03005", MarketingConstants.CENTER_PRE_CODE), "事件不存在"),
    ONLY_CAN_DELTE_DISABLE_EVENT(String.format("%s03006", MarketingConstants.CENTER_PRE_CODE), "只能删除已禁用的事件"),
    EVENT_CODE_CONFLICT(String.format("%s03007", MarketingConstants.CENTER_PRE_CODE), "事件代码不能重复使用"),

    TIME_FORMAT_ERROR(String.format("%s03008", MarketingConstants.CENTER_PRE_CODE), "%s格式异常%s"),
    EVENT_CANNOT_NULL(String.format("%s03009", MarketingConstants.CENTER_PRE_CODE), "事件不能为空"),
    EVENT_CODE_MULTIPLE(String.format("%s03010", MarketingConstants.CENTER_PRE_CODE), "同一个事件码存在多个有效事件，请联系管理员确认数据异常情况"),
    PRESET_EVENT_CANNOT_EDIT_CODE(String.format("%s03011", MarketingConstants.CENTER_PRE_CODE), "不能更改系统事件的事件码"),

    // 促销
    PRESENT_NAME_REPEAT(String.format("%s04001", MarketingConstants.CENTER_PRE_CODE), "赠品组名称已存在"),
    PRESENT_RECORD_NOT_EXIST(String.format("%s04002", MarketingConstants.CENTER_PRE_CODE), "赠品记录不存在"),
    PRESENT_REFER(String.format("%s04003", MarketingConstants.CENTER_PRE_CODE), "赠品组已被引用"),


    ITEM_CODE_EMPTY(String.format("%s04004", MarketingConstants.CENTER_PRE_CODE), "商品code不能为空"),
    ITEM_CODE_REPEAT(String.format("%s04005", MarketingConstants.CENTER_PRE_CODE), "商品code重复"),
    ITEM_NOT_EXIST(String.format("%s04006", MarketingConstants.CENTER_PRE_CODE), "商品不存在"),
    ITEM_CODE_ID(String.format("%s04007", MarketingConstants.CENTER_PRE_CODE), "商品id不能为空"),
    ITEM_STORAGE_NOT_ENOUGH(String.format("%s040011", MarketingConstants.CENTER_PRE_CODE), "商品id不能为空"),
    INSTALLMENT_REPEAT(String.format("%s04010", MarketingConstants.CENTER_PRE_CODE), "分期数据已存在"),
    ;

    private String code;

    private String msg;

    MarketingBizExceptionCodeEnum(String code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    @Override
    public String getCode() {
        return this.code;
    }

    @Override
    public String getMsg() {
        return this.msg;
    }
}
