/*
 * *
 *  * @(#)IActivityApi.java 2.0.0 18-11-28 下午3:25
 *  * author: luo.lei
 *  * Copyright (c)  2018, YUNXI. All rights reserved.
 *  * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 */
package com.dtyunxi.yundt.imkt.bundle.common.center.marketing.api.service;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.imkt.bundle.common.center.marketing.api.dto.BatchEditDataReqDto;
import com.dtyunxi.yundt.imkt.bundle.common.center.marketing.api.dto.request.limit.MarketingLimitReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.List;

/**
 * 营销限制服务接口
 *
 * @author 消息
 * @since 2.0.0
 */

@Api(tags = {"营销中心：营销限制服务接口API"})
@FeignClient(contextId="com-dtyunxi-yundt-cube-biz-marketing-api-common-service-IMarketingLimitApi", name = "${yundt.cube.center.marketing.api.name:yundt-cube-center-marketing}", path = "/v1/marketing-limit", url = "${yundt.cube.center.marketing.api:}")
public interface IMarketingLimitApi {

    @PostMapping("/batch")
    @ResponseBody
    @ApiOperation(value = "批量保存营销限制[覆盖式保存]", notes = "批量保存营销限制[覆盖式保存]")
    RestResponse<List<Long>> save(@RequestBody BatchEditDataReqDto<MarketingLimitReqDto> batchEditReqDto);

}
