/*
 * *
 *  * @(#)IActivityApi.java 2.0.0 18-11-28 下午3:25
 *  * author: luo.lei
 *  * Copyright (c)  2018, YUNXI. All rights reserved.
 *  * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 */
package com.dtyunxi.yundt.imkt.bundle.common.center.marketing.api.service;

import com.dtyunxi.rest.RestResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

/**
 * 营销中心：标签组依赖管理api
 *
 * @author 消息
 * @since 2.0.0
 */
@Api(tags = {"营销中心：标签组依赖管理api"})
@FeignClient(contextId="com-dtyunxi-yundt-cube-biz-marketing-api-common-service-ITagTaskDependApi", name = "${yundt.cube.center.marketing.api.name:yundt-cube-center-marketing}", path = "/v1/tagTaskDepend", url = "${yundt.cube.center.marketing.api:}")
public interface ITagTaskDependApi {

    @PostMapping
    @ResponseBody
    @ApiOperation(value = "标签组更新状态依赖管理", notes = "标签组更新状态依赖管理")
    RestResponse<Void> update(@RequestParam("id") String id, @RequestParam("status") Integer status);

    @DeleteMapping
    @ResponseBody
    @ApiOperation(value = "删除人群包依赖管理", notes = "删除人群包依赖管理")
    RestResponse<Void> delete(@RequestParam("id") String id);
}
