/*
 * *
 *  * @(#)IActivityApi.java 2.0.0 18-11-28 下午3:25
 *  * author: luo.lei
 *  * Copyright (c)  2018, YUNXI. All rights reserved.
 *  * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 */
package com.dtyunxi.yundt.imkt.bundle.common.center.marketing.api.service.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.imkt.bundle.common.center.marketing.api.dto.response.BocReportDataRespDto;
import com.dtyunxi.yundt.imkt.bundle.common.center.marketing.api.dto.response.BocColumnDataRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.List;

/**
 * 营销中心：提供boc报表数据
 *
 * @author shenfei
 * @since 2.0.0
 */
@Api(tags = {"营销中心：提供boc报表数据查询api"})
@FeignClient(contextId="com-dtyunxi-yundt-cube-biz-marketing-api-common-service-IMarketingBocReportQueryApi", name = "${yundt.cube.center.marketing.api.name:yundt-cube-center-marketing}", path = "/v1/marketing/data", url = "${yundt.cube.center.marketing.api:}")
public interface IMarketingBocReportQueryApi {

    @GetMapping("/column")
    @ResponseBody
    @ApiOperation(value = "栏位查询主动营销数据", notes = "栏位查询主动营销数据")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "instanceId", value = "应用实例", dataType = "Long", paramType = "query"),
            @ApiImplicitParam(name = "startTime", value = "开始时间", dataType = "string", paramType = "query"),
            @ApiImplicitParam(name = "endTime", value = "结束时间", dataType = "string", paramType = "query")
    })
    RestResponse<List<BocColumnDataRespDto>> queryMarketingData(@RequestParam(value = "instanceId",required = false) Long instanceId , @RequestParam(value = "startTime",required = false) String startTime, @RequestParam(value = "endTime",required = false) String endTime);

    @GetMapping("/report")
    @ResponseBody
    @ApiOperation(value = "查询优惠券使用报表数据", notes = "查询优惠券使用报表数据")
    RestResponse<List<BocReportDataRespDto>> queryCouponUseReport(@RequestParam(value = "instanceId",required = false) Long instanceId , @RequestParam(value = "day",required = false ,defaultValue = "7") Integer day);

}
