/*
 * *
 *  * @(#)IActivityApi.java 2.0.0 18-11-28 下午3:25
 *  * author: luo.lei
 *  * Copyright (c)  2018, YUNXI. All rights reserved.
 *  * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 */
package com.dtyunxi.yundt.imkt.bundle.common.center.marketing.api.service.query;


import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.imkt.bundle.common.center.marketing.api.dto.request.OperatorReqDto;
import com.dtyunxi.yundt.imkt.bundle.common.center.marketing.api.dto.response.limit.MarketingLimitRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.List;


/**
 * 营销限制服务接口
 *
 * @author 消息
 * @since 2.0.0
 */
@Api(tags = {"营销中心：营销限制服务接口API"})
@FeignClient(name = "${yundt.cube.center.marketing.api.name:yundt-cube-center-marketing}", path = "/v1/marketing-limit", url = "${yundt.cube.center.marketing.api:}")
public interface IMarketingLimitQueryApi {


    @GetMapping("/list")
    @ResponseBody
    @ApiImplicitParams({
            @ApiImplicitParam(name = "pushChannel", value = "渠道类型", dataType = "Integer", paramType = "query"),
            @ApiImplicitParam(name = "type", value = "营销类型", dataType = "Integer", paramType = "query")})
    @ApiOperation(value = "营销限制列表", notes = "营销限制列表")
    RestResponse<List<MarketingLimitRespDto>> getList(@RequestParam(value = "pushChannel", required = false) Integer pushChannel,
                                                      @RequestParam(value = "type", required = false) Integer type, @SpringQueryMap OperatorReqDto operator);

}
