/*
 * *
 *  * @(#)IActivityApi.java 2.0.0 18-11-28 下午3:25
 *  * author: luo.lei
 *  * Copyright (c)  2018, YUNXI. All rights reserved.
 *  * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 */
package com.dtyunxi.yundt.imkt.bundle.common.center.marketing.api.service.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.imkt.bundle.common.center.marketing.api.dto.response.TagReferanceRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.List;

/**
 * 标签引用查询服务
 *
 * @author 消息
 * @since 2.0.0
 */
@Api(tags = {"营销中心：标签引用查询服务API"})
@FeignClient(contextId="com-dtyunxi-yundt-cube-biz-marketing-api-common-service-query-ITagReferenceQueryApi", name = "${yundt.cube.center.marketing.api.name:yundt-cube-center-marketing}", path = "/v1/tag/reference", url = "${yundt.cube.center.marketing.api:}")
public interface ITagReferenceQueryApi{


    @GetMapping("/{id}")
    @ResponseBody
    @ApiOperation(value = "根据标签id查询标签是否被营销引用", notes = "查询标签是否被营销引用")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "标签id", dataType = "Long", paramType = "path")
    })
    RestResponse<TagReferanceRespDto> queryTagReferenceByMarketing(@PathVariable("id") Long id);

    @GetMapping("/group/{groupId}")
    @ResponseBody
    @ApiOperation(value = "根据标签分组id查询标签分组是否被营销引用", notes = "查询标签分组是否被营销引用")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "groupId", value = "标签分组id", dataType = "Long", paramType = "path")
    })
    RestResponse<TagReferanceRespDto> queryTagGroupReferenceByMarketing(@PathVariable("groupId") Long groupId);

    @GetMapping("/batch")
    @ResponseBody
    @ApiOperation(value = "根据标签id集合批量查询标签是否被营销引用", notes = "根据标签id集合批量查询标签是否被营销引用")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "ids", value = "标签id列表", dataType = "Array", paramType = "query")
    })
    RestResponse<List<Long>> batchQueryTagReferenceByMarketing(@RequestParam("ids") List<Long> ids);

    @GetMapping("/group/batch")
    @ResponseBody
    @ApiOperation(value = "根据标签分组id集合批量查询标签分组是否被营销引用", notes = "根据标签分组id集合批量查询标签分组是否被营销引用")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "groupIds", value = "标签分组id列表", dataType = "Array", paramType = "query")
    })
    RestResponse<List<Long>> batchQueryTagGroupReferenceByMarketing(@RequestParam("groupIds") List<Long> groupIds);

}
