/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.commons.mq.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.huieryun.lock.api.ILockService;
import com.dtyunxi.huieryun.lock.api.Mutex;
import com.dtyunxi.yundt.commons.mq.config.RetryMessageVo;
import com.dtyunxi.yundt.commons.mq.service.ICommonsErrorMsgService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service(value="commonsErrorMsgService")
public class CommonsErrorMsgServiceImpl
implements ICommonsErrorMsgService {
    private static Logger logger = LoggerFactory.getLogger(CommonsErrorMsgServiceImpl.class);
    @Resource
    private ICacheService commonsCacheService;
    @Autowired(required=false)
    private ILockService commonsLockService;
    private static final int CACHE_EXPIRE_TIME = 604800;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Async
    public void dumpErrorMsg(RetryMessageVo retryMessageVo) {
        String now = new DateTime().toString("yyyyMMddHH");
        String table = "YUNDT_COMMONS_MQ_MSG_SEND_FAIL_" + now;
        Mutex mutex = this.commonsLockService.lock(table, now);
        try {
            if (null != mutex) {
                List retryMessageVos = this.commonsCacheService.getList(table, RetryMessageVo.class);
                List list = retryMessageVos = CollectionUtils.isEmpty((Collection)retryMessageVos) ? new ArrayList() : retryMessageVos;
                if (null != retryMessageVo && !retryMessageVos.contains((Object)retryMessageVo)) {
                    retryMessageVos.add(retryMessageVo);
                    logger.info("\u5f53\u524d\u9700\u8981\u91cd\u53d1\u6d88\u606f\u5217\u8868\u4e3a:{}", (Object)JSON.toJSONString((Object)((Object)retryMessageVo)));
                    this.commonsCacheService.rpush(table, retryMessageVos, 604800);
                }
            } else {
                logger.error("\u83b7\u53d6\u9501\u5931\u8d25");
            }
        }
        finally {
            this.commonsLockService.unlock(mutex);
        }
    }

    @Override
    public List<RetryMessageVo> queryErrorMsg(Date date) {
        String lastFix = new DateTime((Object)date).toString("yyyyMMddHH");
        String fullKey = "YUNDT_COMMONS_MQ_MSG_SEND_FAIL_" + lastFix;
        return this.commonsCacheService.getList(fullKey, RetryMessageVo.class);
    }
}

