/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.commons.api;

import com.dtyunxi.dto.ResponseDto;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.yundt.commons.api.AbstractApi;
import com.dtyunxi.yundt.commons.api.IBaseQueryApi;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractBaseQueryApi
extends AbstractApi
implements IBaseQueryApi {
    @Override
    public <R extends BaseEo> ResponseDto<R> queryById(Long id, Class<R> clazz) {
        return new ResponseDto(this.getBaseDas(clazz.getSimpleName()).selectByPrimaryKey(id));
    }

    @Override
    public <R extends BaseEo> ResponseDto<List<R>> queryByBatchIds(List<Long> ids, Class<R> clazz) {
        ArrayList batchResult = new ArrayList();
        for (Long id : ids) {
            Object record = this.getBaseDas(clazz.getSimpleName()).selectByPrimaryKey(id);
            batchResult.add(record);
        }
        return new ResponseDto(batchResult);
    }

    @Override
    public <R extends BaseEo> ResponseDto<List<R>> query(R dto) {
        List<R> list = this.getBaseDas(dto.getClass().getSimpleName()).select(dto, false);
        return new ResponseDto(list);
    }

    @Override
    public <R extends BaseEo> ResponseDto<List<R>> query(R dto, List<SqlFilter> sqlFilters) {
        dto.setSqlFilters(sqlFilters);
        List<R> list = this.getBaseDas(dto.getClass().getSimpleName()).select(dto);
        return new ResponseDto(list);
    }

    @Override
    public <R extends BaseEo> ResponseDto<List<R>> queryAll(Class<R> clazz) {
        List list = this.getBaseDas(clazz.getSimpleName()).selectAll();
        return new ResponseDto(list);
    }

    @Override
    public <R extends BaseEo> ResponseDto<PageInfo<R>> queryByPage(R dto, Integer pageNumber, Integer pageSize) {
        PageInfo<R> page = this.getBaseDas(dto.getClass().getSimpleName()).selectPage(dto, pageNumber, pageSize);
        return new ResponseDto(page);
    }

    @Override
    public <R extends BaseEo> ResponseDto<PageInfo<R>> queryByPage(R dto, List<SqlFilter> sqlFilters, Integer pageNumber, Integer pageSize) {
        dto.setSqlFilters(sqlFilters);
        PageInfo<R> page = this.getBaseDas(dto.getClass().getSimpleName()).selectPage(dto, pageNumber, pageSize);
        return new ResponseDto(page);
    }

    @Override
    public <R extends BaseEo> ResponseDto<Integer> countCondition(R dto) {
        int count = this.getBaseDas(dto.getClass().getSimpleName()).count(dto);
        return new ResponseDto((Object)count);
    }
}

