/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.commons.config;

import com.dtyunxi.yundt.commons.utils.ClassScannerUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javassist.ClassClassPath;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.AttributeInfo;
import javassist.bytecode.annotation.Annotation;
import javassist.bytecode.annotation.MemberValue;
import javassist.bytecode.annotation.StringMemberValue;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.transaction.annotation.Transactional;

public abstract class TransactionBeanPostProcessorConfig
implements BeanDefinitionRegistryPostProcessor {
    private static Logger logger = LoggerFactory.getLogger(TransactionBeanPostProcessorConfig.class);

    public abstract String getTransactionManagerName();

    public List<String> getComponentScanPackage() {
        return Lists.newArrayList((Object[])new String[]{"com.dtyunxi.yundt.cmpt.*.service.impl"});
    }

    public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry beanDefinitionRegistry) throws BeansException {
        ClassPool pool = new ClassPool(true);
        ClassClassPath classPath = new ClassClassPath(this.getClass());
        pool.insertClassPath((ClassPath)classPath);
        HashSet transactionServiceImplClass = Sets.newHashSet();
        if (CollectionUtils.isNotEmpty(this.getComponentScanPackage())) {
            for (String pack : this.getComponentScanPackage()) {
                transactionServiceImplClass.addAll(ClassScannerUtil.getAnnotationClasses(pack, Transactional.class));
            }
        } else {
            transactionServiceImplClass.addAll(ClassScannerUtil.getAnnotationClasses("com.dtyunxi.yundt.cmpt.*.service.impl", Transactional.class));
        }
        if (CollectionUtils.isNotEmpty((Collection)transactionServiceImplClass)) {
            for (Class tClass : transactionServiceImplClass) {
                this.processServiceImplClass(beanDefinitionRegistry, pool, tClass);
            }
        }
    }

    private void processServiceImplClass(BeanDefinitionRegistry beanDefinitionRegistry, ClassPool pool, Class clazz) {
        try {
            CtClass beanClass = pool.getCtClass(clazz.getName());
            AnnotationsAttribute classAttribute = (AnnotationsAttribute)beanClass.getClassFile().getAttribute("RuntimeVisibleAnnotations");
            String beanName = this.getBeanName(clazz, classAttribute);
            Annotation transactionAnnotation = classAttribute.getAnnotation("org.springframework.transaction.annotation.Transactional");
            if (transactionAnnotation != null) {
                transactionAnnotation.addMemberValue("transactionManager", (MemberValue)new StringMemberValue(this.getTransactionManagerName(), beanClass.getClassFile().getConstPool()));
                classAttribute.addAnnotation(transactionAnnotation);
                beanClass.getClassFile().addAttribute((AttributeInfo)classAttribute);
            }
            beanClass.setName(clazz.getName() + "Proxy");
            beanDefinitionRegistry.removeBeanDefinition(beanName);
            BeanDefinitionBuilder definitionBuilder = BeanDefinitionBuilder.genericBeanDefinition((Class)beanClass.toClass(this.getClass().getClassLoader()));
            beanDefinitionRegistry.registerBeanDefinition(beanName, (BeanDefinition)definitionBuilder.getBeanDefinition());
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
        }
    }

    private String getBeanName(Class clazz, AnnotationsAttribute classAttribute) {
        StringMemberValue value;
        String beanName = clazz.getSimpleName().substring(0, 1).toLowerCase() + clazz.getSimpleName().substring(1);
        Annotation serviceAnnotation = classAttribute.getAnnotation("org.springframework.stereotype.Service");
        if (serviceAnnotation != null && StringUtils.isNotBlank((CharSequence)(value = (StringMemberValue)serviceAnnotation.getMemberValue("value")).getValue())) {
            beanName = value.getValue();
        }
        return beanName;
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory configurableListableBeanFactory) throws BeansException {
    }
}

