/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.commons.utils;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.annotation.CheckParameter;
import com.dtyunxi.yundt.commons.utils.ReflectUtil;
import com.dtyunxi.yundt.commons.utils.VariableUtil;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class CheckParameterUtil<T> {
    private static final String TYPE_BIG_DECIMAL = "BigDecimal";
    private static final String TYPE_INTEGER = "Integer";
    private static final String TYPE_INT = "int";
    private static final String TYPE_LONG = "Long";
    private static final String TYPE_L = "long";
    private static final String TYPE_DATE = "Date";
    private static final String TYPE_STRING = "String";
    private static final String TYPE_LIST = "List";

    public Map<String, String> check4Object(T t) throws Exception {
        HashMap<String, String> data = new HashMap<String, String>();
        List<Field> fields = ReflectUtil.getAllFields(t.getClass());
        Preconditions.checkNotNull(fields, (Object)"\u5f85\u6821\u9a8c\u7684\u5bf9\u8c61\u57df\u4e3a\u7a7a");
        for (Field field : fields) {
            if (!field.isAnnotationPresent(CheckParameter.class)) continue;
            field.setAccessible(true);
            Object reqValue = field.get(t);
            CheckParameter checkParameter = field.getAnnotation(CheckParameter.class);
            this.validation(reqValue, data, checkParameter, field.getName());
        }
        return data;
    }

    public Map<String, String> check4PrimitiveObject(Object t, CheckParameter checkParameter, String paramName) throws Exception {
        HashMap data = Maps.newHashMap();
        this.validation(t, data, checkParameter, paramName);
        return data;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void validation(Object reqValue, Map<String, String> data, CheckParameter checkParameter, String fieldName) throws IllegalAccessException {
        String name = Strings.isNullOrEmpty((String)checkParameter.fieldName()) ? VariableUtil.underscoreName(fieldName) : checkParameter.fieldName();
        String failCode = checkParameter.failCode();
        if (checkParameter.require()) {
            Preconditions.checkArgument((null != reqValue ? 1 : 0) != 0, (Object)(!Strings.isNullOrEmpty((String)failCode) ? failCode : "\u5c5e\u6027[" + name + "]\u5e94\u8be5\u4e3a\u5fc5\u586b"));
        }
        if (null == reqValue && !Strings.isNullOrEmpty((String)checkParameter.defaultVal())) {
            reqValue = checkParameter.defaultVal();
        }
        int type = checkParameter.type();
        Preconditions.checkArgument((boolean)Lists.newArrayList((Object[])new Integer[]{1, 2, 3}).contains(type), (Object)(!Strings.isNullOrEmpty((String)failCode) ? failCode : "\u5c5e\u6027[" + name + "->" + reqValue + "]\u6ce8\u89e3\u4e2dtype\u503c\u4e0d\u7b26\u5408\u8981\u6c42{1,2,3}"));
        if (null == reqValue) return;
        if (reqValue instanceof Date) {
            String dateFormat = checkParameter.dateFormat();
            try {
                data.put(name, new DateTime((Object)((Date)reqValue)).toString(dateFormat));
                return;
            }
            catch (Exception e) {
                throw new IllegalArgumentException(!Strings.isNullOrEmpty((String)failCode) ? failCode : "\u5c5e\u6027[" + name + "->" + reqValue + "]\u65f6\u95f4\u683c\u5f0f\u4e0d\u6b63\u786e");
            }
        } else if (reqValue instanceof String) {
            Object[] allowVals;
            int length = checkParameter.length();
            Preconditions.checkArgument((((String)reqValue).length() <= length ? 1 : 0) != 0, (Object)(!Strings.isNullOrEmpty((String)failCode) ? failCode : "\u5c5e\u6027[" + name + ":" + String.valueOf(reqValue) + "]\u6bd4\u9884\u8bbe\u7684\u6700\u5927\u957f\u5ea6" + length + "\u8fd8\u5927"));
            String pattern = checkParameter.pattern();
            if (!Strings.isNullOrEmpty((String)pattern)) {
                Preconditions.checkArgument((boolean)Pattern.compile(pattern).matcher((String)reqValue).matches(), (Object)(!Strings.isNullOrEmpty((String)failCode) ? failCode : "\u5c5e\u6027[" + name + "->" + reqValue + "]\u4e0d\u6ee1\u8db3\u9884\u8bbe\u7684\u6b63\u5219\u8868\u8fbe\u5f0f\u89c4\u8303"));
            }
            if (0 < (allowVals = checkParameter.allowVals()).length) {
                ArrayList allowValList = Lists.newArrayList((Object[])allowVals);
                Preconditions.checkArgument((boolean)allowValList.contains(reqValue), (Object)(!Strings.isNullOrEmpty((String)failCode) ? failCode : "\u5c5e\u6027[" + name + "->" + reqValue + "]\u4e0d\u5728\u9884\u8bbe\u8303\u56f4\u4e4b\u7c7b"));
            }
            if (1 == type) {
                data.put(name, (String)reqValue);
                return;
            } else {
                if (2 != type) throw new IllegalArgumentException(!Strings.isNullOrEmpty((String)failCode) ? failCode : "\u5c5e\u6027[" + name + "->" + reqValue + "]\u76ee\u524d\u4e0d\u652f\u6301\u7684\u7c7b\u578b");
                data.put(name, JSON.toJSONString((Object)reqValue));
            }
            return;
        } else if (reqValue instanceof Integer) {
            Object[] allowVals = checkParameter.allowVals();
            if (0 < allowVals.length) {
                ArrayList allowValList = Lists.newArrayList((Object[])allowVals);
                Preconditions.checkArgument((boolean)allowValList.contains(String.valueOf(reqValue)), (Object)(!Strings.isNullOrEmpty((String)failCode) ? failCode : "\u5c5e\u6027[" + name + "->" + reqValue + "]\u4e0d\u5728\u9884\u8bbe\u8303\u56f4\u4e4b\u7c7b"));
            }
            long min = checkParameter.min();
            long max = checkParameter.max();
            Preconditions.checkArgument(((long)((Integer)reqValue).intValue() >= min ? 1 : 0) != 0, (Object)(!Strings.isNullOrEmpty((String)failCode) ? failCode : "\u5c5e\u6027[" + name + "->" + reqValue + "]\u6bd4\u9884\u8bbe\u7684\u6700\u5c0f\u503c\u8fd8\u8981\u5c0f"));
            Preconditions.checkArgument(((long)((Integer)reqValue).intValue() <= max ? 1 : 0) != 0, (Object)(!Strings.isNullOrEmpty((String)failCode) ? failCode : "\u5c5e\u6027[" + name + "->" + reqValue + "]\u6bd4\u9884\u8bbe\u7684\u6700\u5927\u503c\u8fd8\u8981\u5927"));
            data.put(name, String.valueOf(reqValue));
            return;
        } else if (reqValue instanceof Long) {
            long min = checkParameter.min();
            long max = checkParameter.max();
            Preconditions.checkArgument(((Long)reqValue >= min ? 1 : 0) != 0, (Object)(!Strings.isNullOrEmpty((String)failCode) ? failCode : "\u5c5e\u6027[" + name + "->" + reqValue + "]\u6bd4\u9884\u8bbe\u7684\u6700\u5c0f\u503c\u8fd8\u8981\u5c0f"));
            Preconditions.checkArgument(((Long)reqValue <= max ? 1 : 0) != 0, (Object)(!Strings.isNullOrEmpty((String)failCode) ? failCode : "\u5c5e\u6027[" + name + "->" + reqValue + "]\u6bd4\u9884\u8bbe\u7684\u6700\u5927\u503c\u8fd8\u8981\u5927"));
            data.put(name, String.valueOf(reqValue));
            return;
        } else if (reqValue instanceof List) {
            if (3 != type) throw new IllegalArgumentException(!Strings.isNullOrEmpty((String)failCode) ? failCode : "\u5c5e\u6027[" + name + "->" + reqValue + "]\u76ee\u524d\u4e0d\u652f\u6301\u7684\u7c7b\u578b");
            data.put(name, JSON.toJSONString((Object)reqValue));
            return;
        } else {
            if (!(reqValue instanceof BigDecimal)) throw new IllegalArgumentException(!Strings.isNullOrEmpty((String)failCode) ? failCode : "\u5c5e\u6027[" + name + "->" + reqValue + "]\u76ee\u524d\u4e0d\u652f\u6301\u7684\u7c7b\u578b");
            int precision = checkParameter.precision();
            int scale = checkParameter.scale();
            Preconditions.checkArgument((precision >= 0 && scale >= 0 ? 1 : 0) != 0, (Object)(!Strings.isNullOrEmpty((String)failCode) ? failCode : "\u5c5e\u6027[" + name + "->" + reqValue + "]\u6807\u5ea6\u548c\u7cbe\u5ea6\u4e0d\u80fd\u5c0f\u4e8e0"));
            Preconditions.checkArgument((precision >= ((BigDecimal)reqValue).precision() ? 1 : 0) != 0, (Object)(!Strings.isNullOrEmpty((String)failCode) ? failCode : "\u5c5e\u6027[" + name + "->" + reqValue + "]\u6570\u5b57\u7684\u7cbe\u5ea6\u503c\u51fa\u73b0\u9519\u8bef"));
            Preconditions.checkArgument((scale >= ((BigDecimal)reqValue).scale() ? 1 : 0) != 0, (Object)(!Strings.isNullOrEmpty((String)failCode) ? failCode : "\u5c5e\u6027[" + name + "->" + reqValue + "]\u6570\u5b57\u7684\u6807\u5ea6\u503c\u51fa\u73b0\u9519\u8bef"));
            BigDecimal min = new BigDecimal(checkParameter.min());
            BigDecimal max = new BigDecimal(checkParameter.max());
            Preconditions.checkArgument((((BigDecimal)reqValue).compareTo(min) >= 0 ? 1 : 0) != 0, (Object)(!Strings.isNullOrEmpty((String)failCode) ? failCode : "\u5c5e\u6027[" + name + "->" + reqValue + "]\u6bd4\u9884\u8bbe\u7684\u6700\u5c0f\u503c\u8fd8\u8981\u5c0f"));
            Preconditions.checkArgument((((BigDecimal)reqValue).compareTo(max) <= 0 ? 1 : 0) != 0, (Object)(!Strings.isNullOrEmpty((String)failCode) ? failCode : "\u5c5e\u6027[" + name + "->" + reqValue + "]\u6bd4\u9884\u8bbe\u7684\u6700\u5927\u503c\u8fd8\u8981\u5927"));
            data.put(name, String.valueOf(reqValue));
        }
    }

    public void check4Map(T t, Map<String, String> data) throws IllegalArgumentException, Exception {
        List<Field> fields = ReflectUtil.getAllFields(t.getClass());
        Preconditions.checkNotNull(fields, (Object)"\u5f85\u6821\u9a8c\u7684\u5bf9\u8c61\u57df\u4e3a\u7a7a");
        for (Field field : fields) {
            if (!field.isAnnotationPresent(CheckParameter.class)) continue;
            this.checkAndSetReqParamOneByOne(t, data, field);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void checkAndSetReqParamOneByOne(T t, Map<String, String> data, Field field) throws IllegalArgumentException, IllegalAccessException, ParseException {
        Object[] allowVals;
        CheckParameter checkParameter = field.getAnnotation(CheckParameter.class);
        String clzName = field.getType().getSimpleName();
        String name = Strings.isNullOrEmpty((String)checkParameter.fieldName()) ? VariableUtil.underscoreName(field.getName()) : checkParameter.fieldName();
        field.setAccessible(true);
        String reqValue = data.get(name);
        String failCode = checkParameter.failCode();
        if (checkParameter.require()) {
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)reqValue) ? 1 : 0) != 0, (Object)(!Strings.isNullOrEmpty((String)failCode) ? failCode : "\u5c5e\u6027[" + name + "]\u5e94\u8be5\u4e3a\u5fc5\u586b"));
        }
        if (Strings.isNullOrEmpty((String)reqValue) && !Strings.isNullOrEmpty((String)checkParameter.defaultVal())) {
            reqValue = data.containsKey(VariableUtil.underscoreName(checkParameter.defaultVal())) ? data.get(VariableUtil.underscoreName(checkParameter.defaultVal())) : checkParameter.defaultVal();
        }
        int type = checkParameter.type();
        Preconditions.checkArgument((boolean)Lists.newArrayList((Object[])new Integer[]{1, 2, 3}).contains(type), (Object)(!Strings.isNullOrEmpty((String)failCode) ? failCode : "\u5c5e\u6027[" + name + ":" + reqValue + "]\u6ce8\u89e3\u4e2dtype\u503c\u4e0d\u7b26\u5408\u8981\u6c42{1,2,3}"));
        if (Strings.isNullOrEmpty((String)reqValue)) return;
        String pattern = checkParameter.pattern();
        if (!Strings.isNullOrEmpty((String)pattern)) {
            Preconditions.checkArgument((boolean)Pattern.compile(pattern).matcher(reqValue).matches(), (Object)(!Strings.isNullOrEmpty((String)failCode) ? failCode : "\u5c5e\u6027[" + name + ":" + reqValue + "]\u4e0d\u6ee1\u8db3\u9884\u8bbe\u7684\u6b63\u5219\u8868\u8fbe\u5f0f\u89c4\u8303"));
        }
        if (0 < (allowVals = checkParameter.allowVals()).length) {
            ArrayList allowValList = Lists.newArrayList((Object[])allowVals);
            Preconditions.checkArgument((boolean)allowValList.contains(reqValue), (Object)(!Strings.isNullOrEmpty((String)failCode) ? failCode : "\u5c5e\u6027[" + name + ":" + reqValue + "]\u4e0d\u5728\u9884\u8bbe\u8303\u56f4\u4e4b\u7c7b"));
        }
        if (TYPE_DATE.equals(clzName)) {
            String moreThan;
            int length = checkParameter.length();
            Preconditions.checkArgument((reqValue.length() <= length ? 1 : 0) != 0, (Object)(!Strings.isNullOrEmpty((String)failCode) ? failCode : "\u5c5e\u6027[" + name + ":" + reqValue + "]\u6bd4\u9884\u8bbe\u7684\u6700\u5927\u957f\u5ea6" + length + "\u8fd8\u5927"));
            String dateFormat = checkParameter.dateFormat();
            DateTimeFormatter format = DateTimeFormat.forPattern((String)dateFormat);
            field.set(t, DateTime.parse((String)reqValue.substring(0, checkParameter.dateLength()), (DateTimeFormatter)format));
            String lessThan = checkParameter.lessThan();
            if (!Strings.isNullOrEmpty((String)lessThan)) {
                Date other = null;
                if (Pattern.compile("-?[0-9]+").matcher(lessThan).matches()) {
                    other = new DateTime().plusSeconds(Integer.valueOf(lessThan).intValue()).toDate();
                } else if ("now".equals(lessThan)) {
                    other = new Date();
                } else if (!Strings.isNullOrEmpty((String)data.get(VariableUtil.underscoreName(lessThan)))) {
                    String otherField = data.get(VariableUtil.underscoreName(lessThan));
                    other = DateTime.parse((String)otherField.substring(0, checkParameter.dateLength()), (DateTimeFormatter)format).toDate();
                }
                if (null != other) {
                    Preconditions.checkArgument((boolean)DateTime.parse((String)reqValue.substring(0, checkParameter.dateLength()), (DateTimeFormatter)format).toDate().before(other), (Object)(name + "\u5e94\u8be5\u5c0f\u4e8e\u6216\u7b49\u4e8e\u5b57\u6bb5[" + lessThan + "]"));
                }
            }
            if (Strings.isNullOrEmpty((String)(moreThan = checkParameter.moreThan()))) return;
            Date other = null;
            if (Pattern.compile("-?[0-9]+").matcher(moreThan).matches()) {
                other = new DateTime().plusSeconds(Integer.valueOf(moreThan).intValue()).toDate();
            } else if ("now".equals(moreThan)) {
                other = new Date();
            } else if (!Strings.isNullOrEmpty((String)data.get(VariableUtil.underscoreName(moreThan)))) {
                String otherField = data.get(VariableUtil.underscoreName(moreThan));
                other = DateTime.parse((String)otherField.substring(0, checkParameter.dateLength()), (DateTimeFormatter)format).toDate();
            }
            if (other == null) return;
            Preconditions.checkArgument((boolean)DateTime.parse((String)reqValue.substring(0, checkParameter.dateLength()), (DateTimeFormatter)format).toDate().after(other), (Object)(name + "\u5e94\u8be5\u5927\u4e8e\u6216\u7b49\u4e8e\u5b57\u6bb5[" + moreThan + "]"));
            return;
        }
        if (TYPE_BIG_DECIMAL.equals(clzName)) {
            String moreThan;
            BigDecimal decimal;
            try {
                decimal = new BigDecimal(reqValue);
                field.set(t, decimal);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(!Strings.isNullOrEmpty((String)failCode) ? failCode : "\u5c5e\u6027[" + name + ":" + reqValue + "]\u6570\u5b57\u683c\u5f0f\u4e0d\u6b63\u786e");
            }
            int precision = checkParameter.precision();
            int scale = checkParameter.scale();
            Preconditions.checkArgument((precision >= 0 && scale >= 0 ? 1 : 0) != 0, (Object)(!Strings.isNullOrEmpty((String)failCode) ? failCode : "\u5c5e\u6027[" + name + ":" + reqValue + "]\u6807\u5ea6\u548c\u7cbe\u5ea6\u4e0d\u80fd\u5c0f\u4e8e0"));
            Preconditions.checkArgument((precision >= decimal.precision() ? 1 : 0) != 0, (Object)(!Strings.isNullOrEmpty((String)failCode) ? failCode : "\u5c5e\u6027[" + name + ":" + reqValue + "]\u6570\u5b57\u7684\u7cbe\u5ea6\u503c\u51fa\u73b0\u9519\u8bef"));
            Preconditions.checkArgument((scale >= decimal.scale() ? 1 : 0) != 0, (Object)(!Strings.isNullOrEmpty((String)failCode) ? failCode : "\u5c5e\u6027[" + name + ":" + reqValue + "]\u6570\u5b57\u7684\u6807\u5ea6\u503c\u51fa\u73b0\u9519\u8bef"));
            BigDecimal min = new BigDecimal(checkParameter.min());
            BigDecimal max = new BigDecimal(checkParameter.max());
            Preconditions.checkArgument((decimal.compareTo(min) >= 0 ? 1 : 0) != 0, (Object)(!Strings.isNullOrEmpty((String)failCode) ? failCode : "\u5c5e\u6027[" + name + ":" + reqValue + "]\u6bd4\u9884\u8bbe\u7684\u6700\u5c0f\u503c" + min + "\u8fd8\u8981\u5c0f"));
            Preconditions.checkArgument((decimal.compareTo(max) <= 0 ? 1 : 0) != 0, (Object)(!Strings.isNullOrEmpty((String)failCode) ? failCode : "\u5c5e\u6027[" + name + ":" + reqValue + "]\u6bd4\u9884\u8bbe\u7684\u6700\u5927\u503c" + max + "\u8fd8\u8981\u5927"));
            String lessThan = checkParameter.lessThan();
            if (!Strings.isNullOrEmpty((String)lessThan)) {
                String other = data.get(VariableUtil.underscoreName(lessThan));
                Preconditions.checkArgument((decimal.compareTo(new BigDecimal(other)) <= 0 ? 1 : 0) != 0, (Object)(name + "\u5e94\u8be5\u5c0f\u4e8e\u6216\u7b49\u4e8e\u5b57\u6bb5[" + lessThan + "]"));
            }
            if (Strings.isNullOrEmpty((String)(moreThan = checkParameter.moreThan()))) return;
            String other = data.get(VariableUtil.underscoreName(moreThan));
            Preconditions.checkArgument((decimal.compareTo(new BigDecimal(other)) >= 0 ? 1 : 0) != 0, (Object)(name + "\u5e94\u8be5\u5927\u4e8e\u6216\u7b49\u4e8e\u5b57\u6bb5[" + moreThan + "]"));
            return;
        }
        if (TYPE_INTEGER.equals(clzName) || TYPE_INT.equals(clzName)) {
            String moreThan;
            Integer keyInt;
            try {
                keyInt = new Integer(reqValue);
                field.set(t, keyInt);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(!Strings.isNullOrEmpty((String)failCode) ? failCode : "\u5c5e\u6027[" + name + ":" + reqValue + "]\u6570\u5b57\u683c\u5f0f\u4e0d\u6b63\u786e");
            }
            long min = checkParameter.min();
            long max = checkParameter.max();
            Preconditions.checkArgument(((long)keyInt.intValue() >= min ? 1 : 0) != 0, (Object)(!Strings.isNullOrEmpty((String)failCode) ? failCode : "\u5c5e\u6027[" + name + ":" + reqValue + "]\u6bd4\u9884\u8bbe\u7684\u6700\u5c0f\u503c\u8fd8\u8981\u5c0f"));
            Preconditions.checkArgument(((long)keyInt.intValue() <= max ? 1 : 0) != 0, (Object)(!Strings.isNullOrEmpty((String)failCode) ? failCode : "\u5c5e\u6027[" + name + ":" + reqValue + "]\u6bd4\u9884\u8bbe\u7684\u6700\u5927\u503c\u8fd8\u8981\u5927"));
            String lessThan = checkParameter.lessThan();
            if (!Strings.isNullOrEmpty((String)lessThan)) {
                String other = data.get(VariableUtil.underscoreName(lessThan));
                Preconditions.checkArgument((keyInt <= Integer.valueOf(other) ? 1 : 0) != 0, (Object)(name + "\u5e94\u8be5\u5c0f\u4e8e\u6216\u7b49\u4e8e\u5b57\u6bb5[" + lessThan + "]"));
            }
            if (Strings.isNullOrEmpty((String)(moreThan = checkParameter.moreThan()))) return;
            String other = data.get(VariableUtil.underscoreName(moreThan));
            Preconditions.checkArgument((keyInt >= Integer.valueOf(other) ? 1 : 0) != 0, (Object)(name + "\u5e94\u8be5\u5927\u4e8e\u6216\u7b49\u4e8e\u5b57\u6bb5[" + moreThan + "]"));
            return;
        }
        if (TYPE_LONG.equals(clzName) || TYPE_L.equals(clzName)) {
            String moreThan;
            Long keyLong;
            try {
                keyLong = new Long(reqValue);
                field.set(t, keyLong);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(!Strings.isNullOrEmpty((String)failCode) ? failCode : "\u5c5e\u6027[" + name + ":" + reqValue + "]\u6570\u5b57\u683c\u5f0f\u4e0d\u6b63\u786e");
            }
            long min = checkParameter.min();
            long max = checkParameter.max();
            Preconditions.checkArgument((keyLong >= min ? 1 : 0) != 0, (Object)(!Strings.isNullOrEmpty((String)failCode) ? failCode : "\u5c5e\u6027[" + name + ":" + reqValue + "]\u6bd4\u9884\u8bbe\u7684\u6700\u5c0f\u503c\u8fd8\u8981\u5c0f"));
            Preconditions.checkArgument((keyLong <= max ? 1 : 0) != 0, (Object)(!Strings.isNullOrEmpty((String)failCode) ? failCode : "\u5c5e\u6027[" + name + ":" + reqValue + "]\u6bd4\u9884\u8bbe\u7684\u6700\u5927\u503c\u8fd8\u8981\u5927"));
            String lessThan = checkParameter.lessThan();
            if (!Strings.isNullOrEmpty((String)lessThan)) {
                String other = data.get(VariableUtil.underscoreName(lessThan));
                Preconditions.checkArgument((keyLong <= (long)Integer.valueOf(other).intValue() ? 1 : 0) != 0, (Object)(name + "\u5e94\u8be5\u5c0f\u4e8e\u6216\u7b49\u4e8e\u5b57\u6bb5[" + lessThan + "]"));
            }
            if (Strings.isNullOrEmpty((String)(moreThan = checkParameter.moreThan()))) return;
            String other = data.get(VariableUtil.underscoreName(moreThan));
            Preconditions.checkArgument((keyLong >= (long)Integer.valueOf(other).intValue() ? 1 : 0) != 0, (Object)(name + "\u5e94\u8be5\u5927\u4e8e\u6216\u7b49\u4e8e\u5b57\u6bb5[" + moreThan + "]"));
            return;
        }
        if (TYPE_STRING.equals(clzName)) {
            int length = checkParameter.length();
            Preconditions.checkArgument((reqValue.length() <= length ? 1 : 0) != 0, (Object)(!Strings.isNullOrEmpty((String)failCode) ? failCode : "\u5c5e\u6027[" + name + ":" + reqValue + "]\u6bd4\u9884\u8bbe\u7684\u6700\u5927\u957f\u5ea6" + length + "\u8fd8\u5927"));
            Class fastJsonClz = checkParameter.fastJsonClz();
            if (1 == type) {
                field.set(t, reqValue);
                return;
            } else {
                if (2 != type) throw new IllegalArgumentException(!Strings.isNullOrEmpty((String)failCode) ? failCode : "\u5c5e\u6027[" + name + ":" + reqValue + "]\u76ee\u524d\u4e0d\u652f\u6301\u7684\u7c7b\u578b");
                try {
                    field.set(t, JSON.parseObject((String)reqValue, (Class)fastJsonClz));
                    return;
                }
                catch (Exception e) {
                    throw new IllegalArgumentException(!Strings.isNullOrEmpty((String)failCode) ? failCode : "\u5c5e\u6027[" + name + ":" + reqValue + "]json\u89e3\u6790\u51fa\u9519");
                }
            }
        }
        if (!TYPE_LIST.equals(clzName)) throw new IllegalArgumentException(!Strings.isNullOrEmpty((String)failCode) ? failCode : "\u5c5e\u6027[" + name + ":" + reqValue + "]\u76ee\u524d\u4e0d\u652f\u6301\u7684\u7c7b\u578b");
        Class fastJsonClz = checkParameter.fastJsonClz();
        if (3 != type) throw new IllegalArgumentException(!Strings.isNullOrEmpty((String)failCode) ? failCode : "\u5c5e\u6027[" + name + ":" + reqValue + "]\u76ee\u524d\u4e0d\u652f\u6301\u7684\u7c7b\u578b");
        try {
            field.set(t, JSON.parseArray((String)reqValue, (Class)fastJsonClz));
            return;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(!Strings.isNullOrEmpty((String)failCode) ? failCode : "\u5c5e\u6027[" + name + ":" + reqValue + "]json\u89e3\u6790\u51fa\u9519");
        }
    }
}

