/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.commons.utils;

import com.dtyunxi.lang.BusinessRuntimeException;
import com.dtyunxi.yundt.commons.constant.enums.DatePattern;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;

public class DateUtils {
    public static String getDateToString(Date date) {
        if (date == null) {
            return "";
        }
        return new DateTime(date.getTime()).toString(DatePattern.DATETIME_PATTERN.getPattern());
    }

    public static String formatDate(DatePattern pattern, Date date) {
        if (pattern == null) {
            throw new BusinessRuntimeException("\u65e5\u671f\u683c\u5f0f\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        if (date == null) {
            return "";
        }
        return new DateTime(date.getTime()).toString(pattern.getPattern());
    }

    public static Date checkDateParam(String dateTime) {
        Date date = null;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
        if (StringUtils.isNotBlank((CharSequence)dateTime)) {
            try {
                date = sdf.parse(dateTime);
            }
            catch (ParseException e) {
                throw new BusinessRuntimeException("\u65e0\u6548\u7684\u65e5\u671f\u65f6\u95f4\u683c\u5f0f\uff1a" + dateTime);
            }
        }
        return date;
    }

    public static Date getStartOfDay(Date date) {
        return org.apache.commons.lang3.time.DateUtils.truncate((Date)date, (int)5);
    }

    public static Date getEndOfDay(Date date) {
        return org.apache.commons.lang3.time.DateUtils.addMilliseconds((Date)org.apache.commons.lang3.time.DateUtils.ceiling((Date)date, (int)5), (int)-1);
    }
}

