/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.commons.utils;

import com.dtyunxi.app.ServiceContext;
import com.google.common.collect.Maps;
import com.taobao.eagleeye.EagleEye;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserInfoUtil {
    public static Map<String, String> traceMap = Maps.newConcurrentMap();
    private static final Logger logger = LoggerFactory.getLogger(UserInfoUtil.class);

    public static Long getUserInfo() {
        try {
            String traceId = EagleEye.getTraceId();
            ServiceContext context = ServiceContext.getContext();
            Long userId = context.getRequestUserId();
            logger.info("-------------traceId:{},\u83b7\u53d6\u5f53\u524d\u7528\u6237\u767b\u5f55ID:{},context:{}---------------", new Object[]{traceId, userId, context});
            if (userId != null) {
                logger.info("-- \u91cd\u8bbe\u7528\u6237\u767b\u5f55ID:{},context:{}", (Object)userId, (Object)context);
                context.setAttachment("yes.req.userId", userId.toString());
                traceMap.put(traceId + "yes.req.userId", userId.toString());
            } else {
                String userStr = traceMap.get(traceId + "yes.req.userId");
                logger.info("RPCcontext\u65e0\u6cd5\u83b7\u53d6\u4fe1\u606f\uff0c\u4ece\u670d\u52a1\u5668\u7f13\u5b58\u83b7\u53d6\u7684\u7528\u6237\u767b\u5f55ID:{}", (Object)userStr);
                if (StringUtils.isNotBlank((CharSequence)userStr)) {
                    userId = Long.parseLong(userStr);
                }
            }
            return userId;
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u5f53\u524d\u767b\u5f55\u7528\u6237\u4fe1\u606f\u5f02\u5e38=====" + e.getMessage());
            throw new RuntimeException(e);
        }
    }

    public static Long getTenantId() {
        try {
            String traceId = EagleEye.getTraceId();
            ServiceContext context = ServiceContext.getContext();
            Long tenantId = context.getRequestTenantId();
            logger.info("-------------\u83b7\u53d6\u5f53\u524d\u7528\u6237\u79df\u6237ID:{}---------------", (Object)tenantId);
            if (tenantId != null) {
                logger.info("-- \u91cd\u8bbe\u7528\u6237\u79df\u6237ID:{}", (Object)tenantId);
                context.setAttachment("yes.req.tenantId", tenantId.toString());
                traceMap.put(traceId + "yes.req.tenantId", tenantId.toString());
            } else {
                String tenantStr = traceMap.get(traceId + "yes.req.tenantId");
                logger.info("RPCcontext\u65e0\u6cd5\u83b7\u53d6\u4fe1\u606f\uff0c\u4ece\u670d\u52a1\u5668\u7f13\u5b58\u83b7\u53d6\u7684\u79df\u6237ID:{}", (Object)tenantStr);
                if (StringUtils.isNotBlank((CharSequence)tenantStr)) {
                    tenantId = Long.parseLong(tenantStr);
                }
            }
            return tenantId;
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u5f53\u524d\u767b\u5f55\u7528\u6237\u4fe1\u606f\u5f02\u5e38=====" + e.getMessage());
            throw new RuntimeException(e);
        }
    }

    public static Long getApplicationId() {
        try {
            String traceId = EagleEye.getTraceId();
            ServiceContext context = ServiceContext.getContext();
            Long applicationId = context.getRequestApplicationId();
            logger.info("-------------\u83b7\u53d6\u5f53\u524d\u7528\u6237\u5e94\u7528ID:{}---------------", (Object)applicationId);
            if (applicationId != null) {
                logger.info("-- \u91cd\u8bbe\u7528\u6237\u5e94\u7528ID:{}", (Object)applicationId);
                context.setAttachment("yes.req.applicationId", applicationId.toString());
                traceMap.put(traceId + "yes.req.applicationId", applicationId.toString());
            } else {
                String applicationStr = traceMap.get(traceId + "yes.req.applicationId");
                logger.info("RPCcontext\u65e0\u6cd5\u83b7\u53d6\u4fe1\u606f\uff0c\u4ece\u670d\u52a1\u5668\u7f13\u5b58\u83b7\u53d6\u7684\u5e94\u7528ID:{}", (Object)applicationStr);
                if (StringUtils.isNotBlank((CharSequence)applicationStr)) {
                    applicationId = Long.parseLong(applicationStr);
                }
            }
            return applicationId;
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u5f53\u524d\u7528\u6237\u5e94\u7528ID\u5f02\u5e38=====" + e.getMessage());
            throw new RuntimeException(e);
        }
    }

    public static String getRequestTerminalTypeString() {
        try {
            String terminalCode = ServiceContext.getContext().getRequestTerminalTypeString();
            logger.info("-------------\u83b7\u53d6\u5f53\u524d\u7ec8\u7aefCode:{}---------------", (Object)terminalCode);
            return terminalCode;
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u5f53\u524d\u7528\u6237\u5e94\u7528ID\u5f02\u5e38=====" + e.getMessage());
            throw new RuntimeException(e);
        }
    }
}

