package com.dtyunxi.yundt.cube.center.inventory.api;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.WarehouseAreaMappingReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.WarehouseAreaMappingRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;

import java.util.List;

/**
* 仓库区域映射规则服务接口
*
* @author 妙才
* @since 2022-12-24
*/
@Api(tags = {"仓库区域映射规则服务"})
@FeignClient(
    contextId = "com-dtyunxi-yundt-cube-center-inventory-api-IWarehouseAreaMappingApi",
    name = "${yundt.cube.center.inventory.api.name:ty-cube-center-inventory}",
    path = "/v1/warehouseAreaMapping",
    url = "${yundt.cube.center.inventory.api:}"
)
public interface IWarehouseAreaMappingApi {

    /**
    * 新增仓库区域映射规则
    *
    * @param addReqDto 仓库区域映射规则请求对象
    * @return 处理结果
    */
    @PostMapping("")
    @ApiOperation(value = "新增仓库区域映射规则", notes = "新增仓库区域映射规则")
    RestResponse<Long> addWarehouseAreaMapping(@RequestBody WarehouseAreaMappingReqDto addReqDto);

    /**
     * 批量保存
     *
     * @param addReqDto 仓库区域映射规则请求对象
     * @return 处理结果
     */
    @PostMapping("/batchSave")
    @ApiOperation(value = "新增仓库区域映射规则", notes = "新增仓库区域映射规则")
    RestResponse<Void> batchSaveWarehouseAreaMapping(@RequestBody List<WarehouseAreaMappingReqDto> addReqDto);


    /**
     * 开关
     *
     * @param addReqDto 仓库区域映射规则请求对象
     * @return 处理结果
     */
    @PostMapping("/enable")
    @ApiOperation(value = "新增仓库区域映射规则", notes = "新增仓库区域映射规则")
    RestResponse<Void> enable(@RequestBody WarehouseAreaMappingReqDto addReqDto);

    /**
    * 修改仓库区域映射规则
    *
    * @param modifyReqDto 仓库区域映射规则请求对象
    * @return 处理结果
    */
    @PutMapping("")
    @ApiOperation(value = "修改仓库区域映射规则", notes = "修改仓库区域映射规则")
    RestResponse<Void> modifyWarehouseAreaMapping(@RequestBody WarehouseAreaMappingReqDto modifyReqDto);

    /**
    * 删除仓库区域映射规则
    *
    * @param ids        仓库区域映射规则删除数据ID
    * @param instanceId 实例ID
    * @return 处理结果
    */
    @DeleteMapping("/{ids}")
    @ApiOperation(value = "删除仓库区域映射规则", notes = "删除仓库区域映射规则")
    RestResponse<Void> removeWarehouseAreaMapping(@PathVariable("ids") String ids,@RequestParam("instanceId") Long instanceId);
}
