/**
 * @(#)CsChannelInventoryApi.java 1.0 2022/03/07 14:51
 * <p>
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.inventory.api.cs.external.eas;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.in.CsInPlannedOrderGenerateExposedReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.in.CsInPlannedOrderGenerateReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.in.CsPlannedCancelReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.in.CsWmsCancelReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.out.CsOutPlannedOrderGenerateReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
* CsChannelInventoryApi
*
* @author jingran
* @Date: 2022/03/07 14:51
* @since 1.0.0
*/
@Api(tags = {"对外EAS接口"})
@FeignClient(name = "${yundt.cube.center.inventory.api.name: yundt-cube-center-inventory}", path = "/v1/external/eas", url = "${yundt.cube.center.inventory.api:}")
public interface ICsEasApi {

    /**
     * EAS取消单据
     *
     * @param csWmsCancelReqDto
     * @return
     */
    @PostMapping(value = "/cancel", produces = "application/json")
    @ApiOperation(value = "EAS取消单据", notes = "EAS取消单据")
    RestResponse<String> cancel(@Validated @RequestBody CsWmsCancelReqDto csWmsCancelReqDto);

    /**
     * 生成单据（采购、委外、生产订单）
     * 内部测试用
     *
     * @param plannedOrderGenerateReqDto
     * @return
     */
    @PostMapping(value = "/generatePlannedOrder", produces = "application/json")
    @ApiOperation(value = "生成单据", notes = "生成单据")
    RestResponse<Long> generatePlannedOrder(@Validated @RequestBody CsInPlannedOrderGenerateReqDto plannedOrderGenerateReqDto);


    /**
     * 生成退货单据（采购退货、委外退货、生产退）
     * 内部测试用
     *
     * @param plannedOrderGenerateReqDto
     * @return
     */
    @PostMapping(value = "/generateRetreatOrder", produces = "application/json")
    @ApiOperation(value = "生成退货单据", notes = "生成退货单据")
    RestResponse<Long> generateRetreatOrder(@RequestBody CsOutPlannedOrderGenerateReqDto plannedOrderGenerateReqDto);


    /**
     * 生成单据（采购、委外、生产订单）
     * 对外暴露
     *
     * @param plannedOrderGenerateExposedReqDto
     * @return
     */
    @PostMapping(value = "/generatePlannedOrderExposed", produces = "application/json")
    @ApiOperation(value = "生成单据（采购、委外、生产订单）", notes = "生成单据（采购、委外、生产订单）")
    RestResponse<Long> generatePlannedOrderExposed(@Validated @RequestBody CsInPlannedOrderGenerateExposedReqDto plannedOrderGenerateExposedReqDto);

    /**
     * 生成退货单据（采购退货、委外退货、生产退）
     * 对外暴露
     *
     * @param plannedOrderGenerateExposedReqDto
     * @return
     */
    @PostMapping(value = "/generateRetreatOrderExposed", produces = "application/json")
    @ApiOperation(value = "生成退货单据（采购退货、委外退货、生产退", notes = "生成退货单据（采购退货、委外退货、生产退")
    RestResponse<Long> generateRetreatOrderExposed(@RequestBody CsInPlannedOrderGenerateExposedReqDto plannedOrderGenerateExposedReqDto);

    /**
     * EAS取消计划单据
     * 对外暴露
     *
     * @param plannedCancelReqDto
     * @return
     */
    @PostMapping(value = "/plannedOrderExposedCancel", produces = "application/json")
    @ApiOperation(value = "EAS取消计划单据", notes = "EAS取消计划单据")
    RestResponse<String> plannedOrderExposedCancel(@Validated @RequestBody CsPlannedCancelReqDto plannedCancelReqDto);


}