/**
 * @(#)CsChannelInventoryApi.java 1.0 2022/03/07 14:51
 * <p>
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.inventory.api.cs.external.wms;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.in.CsPlannedCancelReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.in.CsWmsCancelReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.in.CsWmsInSendBackReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.out.CsWmsOutSendBackReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * CsChannelInventoryApi
 *
 * @author jingran
 * @Date: 2022/03/07 14:51
 * @since 1.0.0
 */
@Api(tags = {"对外WMS接口"})
@FeignClient(name = "${yundt.cube.center.inventory.api.name: yundt-cube-center-inventory}", path = "/v1/external/wms", url = "${yundt.cube.center.inventory.api:}")
public interface ICsWmsApi {

    /**
     * wms补充物流信息
     *
     * @param csWmsInSendBackReqDto
     * @return
     */
    @PostMapping(value = "/appendLogistics", produces = "application/json")
    @ApiOperation(value = "wms补充物流信息", notes = "wms补充物流信息")
    RestResponse<Void> appendLogistics(@RequestBody CsWmsOutSendBackReqDto csWmsInSendBackReqDto);

    /**
     * wms入库回传
     *
     * @param csWmsInSendBackReqDto
     * @return
     */
    @PostMapping(value = "/inSendBack", produces = "application/json")
    @ApiOperation(value = "wms入库回传", notes = "wms入库回传")
    RestResponse<String> inSendBack(@Validated @RequestBody CsWmsInSendBackReqDto csWmsInSendBackReqDto);


    /**
     * wms出库回传
     *
     * @param csWmsOutSendBackReqDto
     * @return
     */
    @PostMapping(value = "/outSendBack", produces = "application/json")
    @ApiOperation(value = "wms出库回传", notes = "wms出库回传")
    RestResponse<String> outSendBack(@Validated @RequestBody CsWmsOutSendBackReqDto csWmsOutSendBackReqDto);

    /**
     * wms取消单据
     *
     * @param csWmsCancelReqDto
     * @return
     */
    @PostMapping(value = "/cancel", produces = "application/json")
    @ApiOperation(value = "wms取消单据", notes = "wms取消单据")
    @Deprecated
    RestResponse<String> cancel(@Validated @RequestBody CsWmsCancelReqDto csWmsCancelReqDto);

    /**
     * wms取消退货单据
     *
     * @param csWmsCancelReqDto
     * @return
     */
    @PostMapping(value = "/cancelRetreat", produces = "application/json")
    @ApiOperation(value = "wms取消退货单据", notes = "wms取消退货单据")
    @Deprecated
    RestResponse<String> cancelRetreat(@Validated @RequestBody CsWmsCancelReqDto csWmsCancelReqDto);

    /**
     * WMS取消计划单据
     * 对外暴露
     *
     * @param plannedCancelReqDto
     * @return
     */
    @PostMapping(value = "/plannedOrderExposedCancel", produces = "application/json")
    @ApiOperation(value = "WMS取消计划单据", notes = "WMS取消计划单据")
    @Deprecated
    RestResponse<String> plannedOrderExposedCancel(@Validated @RequestBody CsPlannedCancelReqDto plannedCancelReqDto);

    /**
     * WMS取消计划退货单据
     * 对外暴露
     *
     * @param plannedCancelReqDto
     * @return
     */
    @PostMapping(value = "/retreatExposedCancel", produces = "application/json")
    @ApiOperation(value = "WMS取消计划退货单据", notes = "WMS取消计划退货单据")
    @Deprecated
    RestResponse<String> retreatExposedCancel(@Validated @RequestBody CsPlannedCancelReqDto plannedCancelReqDto);

    /**
     * WMS发起的取消
     * 所有有关WMS发起的取消，都会走到这里
     *
     * @param csWmsCancelReqDto
     * @return
     */
    @PostMapping(value = "/cancelInstruct", produces = "application/json")
    @ApiOperation(value = "wms取消单据", notes = "wms取消单据")
    RestResponse<String> cancelInstruct(@Validated @RequestBody CsWmsCancelReqDto csWmsCancelReqDto);

}