/**
 * @(#)ICsCurrentTimeInventoryQueryApi.java 1.0 2022/05/24 11:06
 * <p>
 * Copyright (c) 2022, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.inventory.api.cs.inventory;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsInventoryPreemptionQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsRealTimeInventoryQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.inventory.CsInventoryPreemptionRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.inventory.CsRealTimeInventoryRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * 实时库存查询api
 *
 * @author wenyi
 * @Date: 2022/05/24 11:06
 * @since 1.0.0
 */
@Api(tags = {"csCurrentTimeInventoryQueryApi接口"})
@FeignClient(name = "${yundt.cube.center.inventory.api.name: yundt-cube-center-inventory}", path = "/v2/csCurrentTimeInventory", url = "${yundt.cube.center.inventory.api:}")
public interface ICsCurrentTimeInventoryQueryApi {

    @PostMapping(value = "/queryRealTimeInventory", produces = "application/json")
    @ApiOperation(value = "实时库存列表查询", notes = "实时库存列表查询")
    RestResponse<PageInfo<CsRealTimeInventoryRespDto>> queryRealTimeInventory(@RequestBody CsRealTimeInventoryQueryDto queryDto);

    @PostMapping(value = "/queryRealTimePreemptInventory", produces = "application/json")
    @ApiOperation(value = "实时库存-预占库存查询", notes = "实时库存-预占库存查询")
    RestResponse<PageInfo<CsInventoryPreemptionRespDto>> queryRealTimePreemptInventory(@RequestBody CsInventoryPreemptionQueryDto queryDto);
}