package com.dtyunxi.yundt.cube.center.inventory.api.cs.inventory;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.basics.CsInventoryBasicsQueryReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsInventoryBatchQueryReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsInventoryCommonQueryReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsInventoryPageQueryReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsInventoryWarehouseQueryReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.log.CsActivityInventoryLogPageQueryReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.log.CsInventoryLogPageQueryReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.basics.CsInventoryBasicsQueryRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.inventory.CsInventoryBatchQueryRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.inventory.CsInventoryCommonRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.inventory.CsInventoryPageQueryRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.inventory.CsInventoryWarehouseQueryRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.log.CsActivityInventoryLogPageQueryRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.log.CsActivityInventoryLogRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.log.CsInventoryLogPageQueryRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.log.CsInventoryLogRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * @author jingran
 * @version 1.0
 * @Date 2022/1/14 1:47 下午
 */
@Api(tags = {"库存中心-库存查询相关接口"})
@FeignClient(name = "${yundt.cube.center.inventory.api.name: yundt-cube-center-inventory}", path = "/v2/csInventoryExposedQuery", url = "${yundt.cube.center.inventory.api:}")
public interface ICsInventoryExposedQueryApi {

    /**
     * 库存分页查询
     *
     * @param csInventoryPageQueryReqDto
     * @return
     */
    @PostMapping(value = "/queryInventoryPage", produces = "application/json")
    @ApiOperation(value = "库存分页查询", notes = "库存分页查询")
    RestResponse<PageInfo<CsInventoryPageQueryRespDto>> queryInventoryPage(@Validated @RequestBody CsInventoryPageQueryReqDto csInventoryPageQueryReqDto);

    /**
     * 库存流水分页查询
     *
     * @param csInventoryLogPageQueryReqDto
     * @return
     */
    @PostMapping(value = "/queryInventoryLogPage", produces = "application/json")
    @ApiOperation(value = "库存流水分页查询", notes = "库存流水分页查询")
    RestResponse<PageInfo<CsInventoryLogPageQueryRespDto>> queryInventoryLogPage(@Validated @RequestBody CsInventoryLogPageQueryReqDto csInventoryLogPageQueryReqDto);

    /**
     * 活动库存流水分页查询
     *
     * @param csInventoryLogPageQueryReqDto
     * @return
     */
    @PostMapping(value = "/queryActivityInventoryLogPage", produces = "application/json")
    @ApiOperation(value = "活动库存流水分页查询", notes = "活动库存流水分页查询")
    RestResponse<PageInfo<CsActivityInventoryLogPageQueryRespDto>> queryActivityInventoryLogPage(@Validated @RequestBody CsActivityInventoryLogPageQueryReqDto csInventoryLogPageQueryReqDto);

    /**
     * 库存通用查询接口
     *
     * @param basicsQueryReqDto
     * @return
     */
    @PostMapping(value = "/queryCommonInventory", produces = "application/json")
    @ApiOperation(value = "库存通用查询接口", notes = "库存通用查询接口")
    RestResponse<List<CsInventoryBasicsQueryRespDto>> queryCommonInventory(@Validated @RequestBody CsInventoryBasicsQueryReqDto basicsQueryReqDto);

    /**
     * 库存批次信息查询
     *
     * @param csInventoryBatchQueryReqDto
     * @return
     */
    @PostMapping(value = "/queryBatchInfo", produces = "application/json")
    @ApiOperation(value = "库存批次信息查询", notes = "库存批次信息查询")
    RestResponse<List<CsInventoryBatchQueryRespDto>> queryBatchInfo(@Validated @RequestBody CsInventoryBatchQueryReqDto csInventoryBatchQueryReqDto);

    /**
     * 根据选定批次等信息，查询可用仓库信息
     *
     * @param csInventoryWarehouseQueryReqDto
     * @return
     */
    @PostMapping(value = "/queryWarehouseInfo", produces = "application/json")
    @ApiOperation(tags = { "queryWarehouseInfo" },value = "根据选定批次等信息，查询可用仓库信息", notes = "根据选定批次等信息，查询可用仓库信息")
    RestResponse<List<CsInventoryWarehouseQueryRespDto>> queryWarehouseInfo(@Validated @RequestBody CsInventoryWarehouseQueryReqDto csInventoryWarehouseQueryReqDto);

}
