package com.dtyunxi.yundt.cube.center.inventory.api.cs.inventory;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsInventoryImportResultDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsInventoryTakeStockImportDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsInventoryTakeStockOrderReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsReviewTakeStockOrderReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.inventory.CsTakeStockOrderResultRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import liquibase.pro.packaged.S;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

/**
 * 库存盘点单服务接口
 *
 * @author 宁毅
 * @since 2022-04-25
 */
@Api(tags = {"库存盘点单服务"})
@FeignClient(
        contextId = "com-dtyunxi-yundt-cube-center-inventory-api-ICsInventoryTakeStockOrderApi",
        name = "${yundt.cube.center.inventory.api.name:yundt-cube-center-inventory}",
        path = "/v1/take/stock",
        url = "${yundt.cube.center.inventory.api:}"
)
public interface ICsInventoryTakeStockOrderApi {

    /**
     * 新增库存盘点单
     *
     * @param addReqDto 库存盘点单请求对象
     * @return 处理结果
     */
    @PostMapping("/addInventoryTakeStockOrder")
    @ApiOperation(value = "新增库存盘点单", notes = "新增库存盘点单")
    RestResponse<CsTakeStockOrderResultRespDto> addInventoryTakeStockOrder(@RequestBody CsInventoryTakeStockOrderReqDto addReqDto);

    /**
     * 重新编辑盘点单
     *
     * @param modifyReqDto 库存盘点单请求对象
     * @return 处理结果
     */
    @PostMapping("/modifyInventoryTakeStockOrder")
    @ApiOperation(value = "重新编辑盘点单", notes = "重新编辑盘点单")
    RestResponse<CsTakeStockOrderResultRespDto> modifyInventoryTakeStockOrder(@RequestBody CsInventoryTakeStockOrderReqDto modifyReqDto);

    /**
     * 审核盘点单
     *
     * @param reviewReqDto 审核盘点单
     * @return 处理结果
     */
    @PostMapping("/reviewInventoryTakeStockOrder")
    @ApiOperation(value = "审核盘点单", notes = "审核盘点单")
    RestResponse<Void> reviewInventoryTakeStockOrder(@RequestBody CsReviewTakeStockOrderReqDto reviewReqDto);


    /**
     * 通过订单号提交盘点单
     *
     * @param orderNo 盘点单号
     * @return 处理结果
     */
    @PostMapping("/submitTakeStockOrder")
    @ApiOperation(value = "通过订单号提交盘点单", notes = "通过订单号提交盘点单")
    RestResponse<CsTakeStockOrderResultRespDto> submitTakeStockOrder(@RequestParam("orderNo") String orderNo);


    /**
     * 关闭盘点单
     *
     * @param orderNo 关闭盘点单据号
     * @return 处理结果
     */
    @PostMapping("/closeInventoryTakeStockOrder")
    @ApiOperation(value = "关闭盘点单", notes = "关闭盘点单")
    RestResponse<Void> closeInventoryTakeStockOrder(@RequestParam("orderNo") String orderNo);


    /**
     * 删除库存盘点单
     *
     * @param ids        库存盘点单删除数据ID
     * @param instanceId 实例ID
     * @return 处理结果
     */
    @DeleteMapping("/{ids}")
    @ApiOperation(value = "删除库存盘点单", notes = "删除库存盘点单")
    RestResponse<Void> removeInventoryTakeStockOrder(@PathVariable("ids") String ids, @RequestParam("instanceId") Long instanceId);

    /**
     * 导入盘点单商品
     *
     * @param inventoryTakeStockImportDto
     * @return 处理结果
     */
    @PostMapping(value = "/importTakeStockItem")
    @ApiOperation(value = "导入盘点单商品", notes = "导入盘点单商品")
    RestResponse<CsInventoryImportResultDto> importTakeStockItem(@RequestBody CsInventoryTakeStockImportDto inventoryTakeStockImportDto);

}
