package com.dtyunxi.yundt.cube.center.inventory.api.cs.inventory;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsInventoryTakeStockOrderItemReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;

/**
* 库存盘点单商品信息服务接口
*
* @author 宁毅
* @since 2022-04-25
*/
@Api(tags = {"库存盘点单商品信息服务"})
@FeignClient(
    contextId = "com-dtyunxi-yundt-cube-center-inventory-api-ICsInventoryTakeStockOrderItemApi",
    name = "${yundt.cube.center.inventory.api.name:yundt-cube-center-inventory}",
    path = "/v1/take/stock/item",
    url = "${yundt.cube.center.inventory.api:}"
)
public interface ICsInventoryTakeStockOrderItemApi {

/**
* 新增库存盘点单商品信息
*
* @param addReqDto 库存盘点单商品信息请求对象
* @return 处理结果
*/
@PostMapping("")
@ApiOperation(value = "新增库存盘点单商品信息", notes = "新增库存盘点单商品信息")
RestResponse<Long> addCsInventoryTakeStockOrderItem(@RequestBody CsInventoryTakeStockOrderItemReqDto addReqDto);

    /**
    * 修改库存盘点单商品信息
    *
    * @param modifyReqDto 库存盘点单商品信息请求对象
    * @return 处理结果
    */
    @PutMapping("")
    @ApiOperation(value = "修改库存盘点单商品信息", notes = "修改库存盘点单商品信息")
    RestResponse<Void> modifyCsInventoryTakeStockOrderItem(@RequestBody CsInventoryTakeStockOrderItemReqDto modifyReqDto);

    /**
    * 删除库存盘点单商品信息
    *
    * @param ids        库存盘点单商品信息删除数据ID
    * @param instanceId 实例ID
    * @return 处理结果
    */
    @DeleteMapping("/{ids}")
    @ApiOperation(value = "删除库存盘点单商品信息", notes = "删除库存盘点单商品信息")
    RestResponse<Void> removeCsInventoryTakeStockOrderItem(@PathVariable("ids") String ids,@RequestParam("instanceId") Long instanceId);
}
