package com.dtyunxi.yundt.cube.center.inventory.api.cs.inventory;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsInventoryTakeStockOrderItemQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.inventory.CsInventoryTakeStockOrderItemRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

/**
* 库存盘点单商品信息服务接口
*
* @author 宁毅
* @since 2022-04-25
*/
@Api(tags = {"库存盘点单商品信息服务"})
@FeignClient(
    contextId = "com-dtyunxi-yundt-cube-center-inventory-api-query-ICsInventoryTakeStockOrderItemQueryApi",
    name = "${yundt.cube.center.inventory.api.name:yundt-cube-center-inventory}",
    path = "/v1/take/stock/item",
    url = "${yundt.cube.center.inventory.api:}"
)
public interface ICsInventoryTakeStockOrderItemQueryApi {

    /**
    * 根据id查询库存盘点单商品信息
    *
    * @param id 库存盘点单商品信息id
    * @return   库存盘点单商品信息数据
    */
    @GetMapping("/{id}")
    @ApiOperation(value = "根据id查询库存盘点单商品信息", notes = "根据id查询库存盘点单商品信息")
    RestResponse<CsInventoryTakeStockOrderItemRespDto> queryById(@PathVariable("id") Long id);

    /**
    * 库存盘点单商品信息分页数据
    *
    * @param inventoryTakeStockOrderItemQueryDto   库存盘点单商品信息查询条件
    * @return 库存盘点单商品信息分页数据
    */
    @PostMapping("/page")
    @ApiOperation(value = "库存盘点单商品信息分页数据", notes = "库存盘点单商品信息分页数据")
    RestResponse<PageInfo<CsInventoryTakeStockOrderItemRespDto>> queryByPage(@RequestBody CsInventoryTakeStockOrderItemQueryDto inventoryTakeStockOrderItemQueryDto);

}
