package com.dtyunxi.yundt.cube.center.inventory.api.cs.inventory;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsInventoryTakeStockOrderQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.inventory.CsInventoryTakeStockOrderRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.inventory.CsTakeStockOrderDetailsRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

/**
* 库存盘点单服务接口
*
* @author 宁毅
* @since 2022-04-25
*/
@Api(tags = {"库存盘点单服务"})
@FeignClient(
    contextId = "com-dtyunxi-yundt-cube-center-inventory-api-query-ICsInventoryTakeStockOrderQueryApi",
    name = "${yundt.cube.center.inventory.api.name:yundt-cube-center-inventory}",
    path = "/v1/take/stock",
    url = "${yundt.cube.center.inventory.api:}"
)
public interface ICsInventoryTakeStockOrderQueryApi {

    /**
    * 根据id查询库存盘点单详情
    *
    * @param id 库存盘点单id
    * @return   库存盘点单详情数据
    */
    @GetMapping("/queryById")
    @ApiOperation(value = "根据id查询库存盘点单详情", notes = "根据id查询库存盘点单详情")
    RestResponse<CsTakeStockOrderDetailsRespDto> queryById(@RequestParam("id") Long id);



    /**
     * 根据id查询库存盘点单详情
     *
     * @param orderNo 库存盘点单号
     * @return   库存盘点单详情数据
     */
    @GetMapping("/queryByOrderNo")
    @ApiOperation(value = "根据单号查询库存盘点单详情", notes = "根据单号查询库存盘点单详情")
    RestResponse<CsTakeStockOrderDetailsRespDto> queryByOrderNo(@RequestParam("orderNo") String orderNo);
    /**
    * 库存盘点单分页数据
    *
    * @param inventoryTakeStockOrderQueryDto
    * @return 库存盘点单分页数据
    */
    @PostMapping("/page")
    @ApiOperation(value = "库存盘点单分页数据", notes = "库存盘点单分页数据")
    RestResponse<PageInfo<CsInventoryTakeStockOrderRespDto>> queryByPage(@RequestBody CsInventoryTakeStockOrderQueryDto inventoryTakeStockOrderQueryDto);

}
