package com.dtyunxi.yundt.cube.center.inventory.api.cs.inventory;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsLogicInventoryBalanceReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

/**
 * 逻辑仓库存结存表服务接口
 *
 * @author 宁毅
 * @since 2022-04-26
 */
@Api(tags = {"逻辑仓库存结存表服务"})
@FeignClient(
        contextId = "com-dtyunxi-yundt-cube-center-inventory-api-ICsLogicInventoryBalanceApi",
        name = "${yundt.cube.center.inventory.api.name:yundt-cube-center-inventory}",
        path = "/v1/logic/inventory/balance",
        url = "${yundt.cube.center.inventory.api:}"
)
public interface ICsLogicInventoryBalanceApi {
    /**
     * 调度任务同步逻辑仓库存结存
     *
     * @return void
     */
    @PostMapping("/logicInventoryBalanceSync")
    @ApiOperation(value = "调度任务同步逻辑仓库存结存", notes = "调度任务同步逻辑仓库存结存")
    RestResponse<Void> logicInventoryBalanceSync();

    /**
     * 新增逻辑仓库存结存表
     *
     * @param addReqDto 逻辑仓库存结存表请求对象
     * @return 处理结果
     */
    @PostMapping("")
    @ApiOperation(value = "新增逻辑仓库存结存表", notes = "新增逻辑仓库存结存表")
    RestResponse<Long> addCsLogicInventoryBalance(@RequestBody CsLogicInventoryBalanceReqDto addReqDto);

    /**
     * 修改逻辑仓库存结存表
     *
     * @param modifyReqDto 逻辑仓库存结存表请求对象
     * @return 处理结果
     */
    @PutMapping("")
    @ApiOperation(value = "修改逻辑仓库存结存表", notes = "修改逻辑仓库存结存表")
    RestResponse<Void> modifyCsLogicInventoryBalance(@RequestBody CsLogicInventoryBalanceReqDto modifyReqDto);

    /**
     * 删除逻辑仓库存结存表
     *
     * @param ids        逻辑仓库存结存表删除数据ID
     * @param instanceId 实例ID
     * @return 处理结果
     */
    @DeleteMapping("/{ids}")
    @ApiOperation(value = "删除逻辑仓库存结存表", notes = "删除逻辑仓库存结存表")
    RestResponse<Void> removeCsLogicInventoryBalance(@PathVariable("ids") String ids, @RequestParam("instanceId") Long instanceId);
}
