package com.dtyunxi.yundt.cube.center.inventory.api.cs.inventory;


import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsLogicInventoryBalanceQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.inventory.CsLogicInventoryBalanceRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

/**
 * 逻辑仓库存结存表服务接口
 *
 * @author 宁毅
 * @since 2022-04-26
 */
@Api(tags = {"逻辑仓库存结存表服务"})
@FeignClient(
        contextId = "com-dtyunxi-yundt-cube-center-inventory-api-query-ICsLogicInventoryBalanceQueryApi",
        name = "${yundt.cube.center.inventory.api.name:yundt-cube-center-inventory}",
        path = "/v1/logic/inventory/balance",
        url = "${yundt.cube.center.inventory.api:}"
)
public interface ICsLogicInventoryBalanceQueryApi {

    /**
     * 根据id查询逻辑仓库存结存表
     *
     * @param id 逻辑仓库存结存表id
     * @return 逻辑仓库存结存表数据
     */
    @GetMapping("/{id}")
    @ApiOperation(value = "根据id查询逻辑仓库存结存表", notes = "根据id查询逻辑仓库存结存表")
    RestResponse<CsLogicInventoryBalanceRespDto> queryById(@PathVariable("id") Long id);

    /**
     * 逻辑仓库存结存表分页数据
     *
     * @param logicInventoryBalanceQueryDto
     * @return 逻辑仓库存结存表分页数据
     */
    @PostMapping("/page")
    @ApiOperation(value = "逻辑仓库存结存表分页数据", notes = "逻辑仓库存结存表分页数据")
    RestResponse<PageInfo<CsLogicInventoryBalanceRespDto>> queryByPage(@RequestBody CsLogicInventoryBalanceQueryDto logicInventoryBalanceQueryDto);

}
