/**
 * @(#)CsChannelInventoryApi.java 1.0 2022/03/07 14:51
 * <p>
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.inventory.api.cs.inventory;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsInventoryDateUpdateReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsInventoryOperateReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsInventoryReleasePreemptOperateReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsLogicPreemptInventoryOperateReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * 库存中心-逻辑仓库存对外暴露操作相关接口
 *
 * @author jingran
 * @Date: 2022/03/07 14:51
 * @since 1.0.0
 */
@Api(tags = {"库存中心-逻辑仓库存暴露对外操作相关接口"})
@FeignClient(name = "${yundt.cube.center.inventory.api.name: yundt-cube-center-inventory}", path = "/v2/csLogicInventoryExposed", url = "${yundt.cube.center.inventory.api:}")
public interface ICsLogicInventoryExposedApi {

    /**
     * 库存预占
     * 注意：此接口只会做预占操作，仅仅做库存预占这件事，不会有单据生成或者变动
     *
     * @param inventoryOperateReqDto
     * @return
     */
    @PostMapping(value = "/preemptInventory", produces = "application/json")
    @ApiOperation(value = "库存预占", notes = "库存预占")
    RestResponse<Boolean> preemptInventory(@Validated @RequestBody CsInventoryOperateReqDto inventoryOperateReqDto);

    /**
     * 库存预占，包含单据操作-生成发货通知单
     *
     * @param logicPreemptInventoryOperateReqDto
     * @return
     */
    @PostMapping(value = "/preemptOrderInventory", produces = "application/json")
    @ApiOperation(value = "库存预占，包含单据操作-生成发货通知单", notes = "库存预占，包含单据操作-生成发货通知单")
    RestResponse<Boolean> preemptOrderInventory(@Validated @RequestBody CsLogicPreemptInventoryOperateReqDto logicPreemptInventoryOperateReqDto);

    /**
     * 根据订单号取消单据释放库存
     * 释放预占的逻辑仓库存，同时取消发货通知单
     *
     * @param orderNo
     * @return
     */
    @PostMapping(value = "/{orderNo}/releaseInventory", produces = "application/json")
    @ApiOperation(value = "根据订单号取消单据释放库存，释放预占的逻辑仓库存，同时取消发货通知单", notes = "根据订单号取消单据释放库存，释放预占的逻辑仓库存，同时取消发货通知单")
    RestResponse<Boolean> cancelOrder(@PathVariable("orderNo") String orderNo);

    /**
     * 库存释放
     * 仅仅做库存的释放操作
     *
     * @param inventoryOperateReqDto
     * @return
     */
    @PostMapping(value = "/releaseInventory", produces = "application/json")
    @ApiOperation(value = "库存释放", notes = "库存释放")
    RestResponse<Boolean> releaseInventory(@Validated @RequestBody CsInventoryOperateReqDto inventoryOperateReqDto);

    /**
     * 库存释放，根据订单号找到预占记录进行释放
     *
     * @param releasePreemptOperateReqDto
     * @return
     */
    @PostMapping(value = "/releaseInventoryByPreemption", produces = "application/json")
    @ApiOperation(value = "库存释放，根据订单号找到预占记录进行释放", notes = "库存释放，根据订单号找到预占记录进行释放")
    RestResponse<Boolean> releaseInventoryByPreemption(@Validated @RequestBody CsInventoryReleasePreemptOperateReqDto releasePreemptOperateReqDto);


    /**
     * 批量更新库存有效期
     *
     * @param inventoryDateUpdateReqDtoList 货品批次有效期信息
     * @return
     */
    @PostMapping(value = "/batchUpdateInventoryDate", produces = "application/json")
    @ApiOperation(value = "批量更新库存有效期", notes = "批量更新库存有效期")
    RestResponse<Boolean> batchUpdateInventoryDate(@RequestBody List<CsInventoryDateUpdateReqDto> inventoryDateUpdateReqDtoList);


    /**
     * 批量初始化库存，当库存信息不存在，做入库初始化
     *
     * @param inventoryDateUpdateReqDtoList 货品批次有效期信息
     * @return
     */
    @PostMapping(value = "/batchInitInventory", produces = "application/json")
    @ApiOperation(value = "批量初始化库存", notes = "批量初始化库存")
    RestResponse<Boolean> batchInitInventory(@RequestBody List<CsInventoryDateUpdateReqDto> inventoryDateUpdateReqDtoList);

}