/**
 * @(#)CsLogicInventoryQueryApi.java 1.0 2021/12/29 11:11
 * <p>
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.inventory.api.cs.inventory;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsLogicInventoryQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsLogicInventoryQueryOtherBatchDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.inventory.CsLogicInventoryRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * CsLogicInventoryQueryApi
 *
 * @author jingran
 * @Date: 2021/12/29 11:11
 * @since 1.0.0
 */
@Api(tags = {"CsLogicInventory接口"})
@FeignClient(name = "${yundt.cube.center.inventory.api.name: yundt-cube-center-inventory}", path = "/v2/csLogicInventory", url = "${yundt.cube.center.inventory.api:}")
public interface ICsLogicInventoryQueryApi {

    /**
     * 根据id查询信息
     *
     * @param id
     * @return
     */
    @GetMapping(value = "/{id}/queryByPrimaryKey", produces = "application/json")
    @ApiOperation(value = "根据id查询信息", notes = "根据id查询信息")
    RestResponse<CsLogicInventoryRespDto> queryByPrimaryKey(@PathVariable("id") Long id);

    /**
     * 分页查询
     *
     * @param queryDto
     * @return
     */
    @PostMapping(value = "/page", produces = "application/json")
    @ApiOperation(value = "分页查询逻辑仓货品库存", notes = "分页查询逻辑仓货品库存")
    RestResponse<PageInfo<CsLogicInventoryRespDto>> queryByPage(@Validated @RequestBody CsLogicInventoryQueryDto queryDto);


    /**
     * 参数查询
     *
     * @param queryDto
     * @return
     */
    @PostMapping(value = "/queryByParam", produces = "application/json")
    @ApiOperation(value = "参数查询", notes = "参数查询")
    RestResponse<List<CsLogicInventoryRespDto>> queryByParam(@Validated @RequestBody CsLogicInventoryQueryDto queryDto);

    /**
     * 分页查询可用库存大于0
     *
     * @param queryDto
     * @return
     */
    @PostMapping(value = "/page/availableGtZero", produces = "application/json")
    @ApiOperation(value = "分页查询可用库存大于0", notes = "分页查询可用库存大于0")
    RestResponse<PageInfo<CsLogicInventoryRespDto>> queryAvailableGtZeroByPage(@Validated @RequestBody CsLogicInventoryQueryDto queryDto);

    /**
     * 分页查询除了入参的批次号的其他库存信息
     *
     * @param
     * @return
     */
    @PostMapping(value = "/queryOtherByBatch", produces = "application/json")
    @ApiOperation(value = "分页查询除了入参的批次号的其他库存信息", notes = "分页查询除了入参的批次号的其他库存信息")
    RestResponse<PageInfo<CsLogicInventoryRespDto>> queryOtherByBatch(@Validated @RequestBody CsLogicInventoryQueryOtherBatchDto queryDto);

    /**
     * 查询列表（非模糊参数）
     * @param queryDto 请求参数
     * @return 处理结果
     */
    @PostMapping(value = "/queryInfoList", produces = "application/json")
    @ApiOperation(value = "查询列表（非模糊参数）", notes = "查询列表（非模糊参数）")
    RestResponse<List<CsLogicInventoryRespDto>> queryInfoList(@Validated @RequestBody CsLogicInventoryQueryDto queryDto);

}