/**
 * @(#)CsLogicInventoryTotalQueryApi.java 1.0 2022/01/12 09:18
 * <p>
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.inventory.api.cs.inventory;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsInventoryTotalQueryReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsLogicInventoryTotalBatchQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsLogicInventoryTotalQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.inventory.CsLogicInventoryTotalRespDto;
import com.dtyunxi.yundt.cube.center.inventory.vo.LogicSupplyInventoryVo;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Map;

/**
 * CsLogicInventoryTotalQueryApi
 *
 * @author jingran
 * @Date: 2022/01/12 09:18
 * @since 1.0.0
 */
@Api(tags = {"CsLogicInventoryTotal接口"})
@FeignClient(name = "${yundt.cube.center.inventory.api.name: yundt-cube-center-inventory}", path = "/v1/csLogicInventoryTotal", url = "${yundt.cube.center.inventory.api:}")
public interface ICsLogicInventoryTotalQueryApi {

    /**
     * 根据id查询信息
     *
     * @param id
     * @return
     */
    @GetMapping(value = "/{id}/queryByPrimaryKey", produces = "application/json")
    @ApiOperation(value = "根据id查询信息", notes = "根据id查询信息")
    RestResponse<CsLogicInventoryTotalRespDto> queryByPrimaryKey(@PathVariable("id") Long id);


    @PostMapping(value = "/query/warehouse/totalInventory", produces = "application/json")
    @ApiOperation(value = "批量查询指定仓库货品（总）库存", notes = "批量查询指定仓库货品（总）库存")
    RestResponse<List<CsLogicInventoryTotalRespDto>> queryWarehouseInventory(@RequestBody CsLogicInventoryTotalBatchQueryDto batchQueryDto);

    /**
     * 分页查询总库存商品
     *
     * @param csInventoryTotalQueryReqDto csInventoryTotalQueryReqDto
     * @param pageNum                     当前页
     * @param pageSize                    页大小
     * @return 分页查询总库存商品
     */
    @PostMapping("/page")
    @ApiOperation(value = "分页查询总库存商品", notes = "分页查询总库存商品")
    RestResponse<PageInfo<CsLogicInventoryTotalRespDto>> queryByLogicWarehouseCodePage(@RequestBody CsInventoryTotalQueryReqDto csInventoryTotalQueryReqDto,
                                                                                       @RequestParam(name = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                                                       @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize);
    /**
     * 分页查询可用库存大于0
     *
     * @param queryDto
     * @return
     */
    @PostMapping(value = "/page/availableGtZero", produces = "application/json")
    @ApiOperation(value = "分页查询可用库存大于0", notes = "分页查询可用库存大于0")
    RestResponse<PageInfo<CsLogicInventoryTotalRespDto>> queryAvailableGtZeroByPage(@Validated @RequestBody CsLogicInventoryTotalQueryDto queryDto);

    /**
     * 根据集合查询
     *
     * @param list
     * @return
     */
    @PostMapping(value = "/queryByList", produces = "application/json")
    @ApiOperation(value = "根据集合查询", notes = "根据集合查询")
    RestResponse<List<CsLogicInventoryTotalRespDto>> queryByList(@Validated @RequestBody List<CsLogicInventoryTotalQueryDto> list);

    /**
     * 根据集合查询
     *
     * @param list
     * @return map key-仓库编码，value-仓库对应库存信息
     */
    @PostMapping(value = "/queryMapByList", produces = "application/json")
    @ApiOperation(value = "根据集合查询Map（key-仓库编码，value-仓库对应库存信息）", notes = "根据集合查询Map（key-仓库编码，value-仓库对应库存信息）")
    RestResponse<Map<String, List<CsLogicInventoryTotalRespDto>>> queryMapByList(@Validated @RequestBody List<CsLogicInventoryTotalQueryDto> list);

    @PostMapping(value = "/queryAndSendChangeLog", produces = "application/json")
    @ApiOperation(value = "查询重新供货", notes = "查询重新供货")
    RestResponse<Void> queryAndSendChangeLog(@RequestBody CsInventoryTotalQueryReqDto queryDto);

    @PostMapping(value = "/queryLogicSupplyInventorys", produces = "application/json")
    @ApiOperation(value = "根据仓库编码，货品编码查询供货库存", notes = "根据仓库编码，货品编码查询供货库存")
    RestResponse<List<LogicSupplyInventoryVo>> queryLogicSupplyInventorys(@RequestBody List<String> warehouseCodes,
                                                                         @RequestParam(name = "cargoCodes", required = false) List<String> cargoCodes);


    @PostMapping(value = "/queryLogicSupplyInventory", produces = "application/json")
    @ApiOperation(value = "根据仓库编码查询供货库存", notes = "根据仓库编码查询供货库存")
    RestResponse<List<LogicSupplyInventoryVo>> queryLogicSupplyInventory(@RequestBody List<String> warehouseCodes);
}