package com.dtyunxi.yundt.cube.center.inventory.api.cs.inventory;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsLogisticsInfoReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

;

/**
 * 物流信息表服务接口
 *
 * @author 宁毅
 * @since 2022-05-07
 */
@Api(tags = {"物流信息表服务"})
@FeignClient(
        contextId = "com-dtyunxi-yundt-cube-center-inventory-api-ICsLogisticsInfoApi",
        name = "${yundt.cube.center.inventory.api.name:yundt-cube-center-inventory}",
        path = "/v1/logistics/info",
        url = "${yundt.cube.center.inventory.api:}"
)
public interface ICsLogisticsInfoApi {

    /**
     * 新增物流信息表
     *
     * @param addReqDto 物流信息表请求对象
     * @return 处理结果
     */
    @PostMapping("")
    @ApiOperation(value = "新增物流信息表", notes = "新增物流信息表")
    RestResponse<Long> addCsLogisticsInfo(@RequestBody CsLogisticsInfoReqDto addReqDto);


    /**
     * 物流信息同步
     *
     * @param str 物流信息数据集合
     * @return 处理结果
     */
    @PostMapping("/logisticsInfoSync")
    @ApiOperation(value = "物流信息同步", notes = "物流信息同步")
    RestResponse<Void> logisticsInfoSync(@RequestParam("str") String str);


    /**
     * 修改物流信息表
     *
     * @param modifyReqDto 物流信息表请求对象
     * @return 处理结果
     */
    @PutMapping("")
    @ApiOperation(value = "修改物流信息表", notes = "修改物流信息表")
    RestResponse<Void> modifyCsLogisticsInfo(@RequestBody CsLogisticsInfoReqDto modifyReqDto);

    /**
     * 删除物流信息表
     *
     * @param ids        物流信息表删除数据ID
     * @param instanceId 实例ID
     * @return 处理结果
     */
    @DeleteMapping("/{ids}")
    @ApiOperation(value = "删除物流信息表", notes = "删除物流信息表")
    RestResponse<Void> removeCsLogisticsInfo(@PathVariable("ids") String ids, @RequestParam("instanceId") Long instanceId);
}
