package com.dtyunxi.yundt.cube.center.inventory.api.cs.inventory;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.inventory.CsLogisticsInfoRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 物流信息表服务接口
 *
 * @author 宁毅
 * @since 2022-05-07
 */
@Api(tags = {"物流信息表服务"})
@FeignClient(
        contextId = "com-dtyunxi-yundt-cube-center-inventory-api-query-ICsLogisticsInfoQueryApi",
        name = "${yundt.cube.center.inventory.api.name:yundt-cube-center-inventory}",
        path = "/v1/logistics/info",
        url = "${yundt.cube.center.inventory.api:}"
)
public interface ICsLogisticsInfoQueryApi {

    /**
     * 根据id查询物流信息表
     *
     * @param id 物流信息表id
     * @return 物流信息表数据
     */
    @GetMapping("/{id}")
    @ApiOperation(value = "根据id查询物流信息表", notes = "根据id查询物流信息表")
    RestResponse<CsLogisticsInfoRespDto> queryById(@PathVariable("id") Long id);


    /**
     * 根据CSP单号批量查询物流信息
     *
     * @param cspNoList CSP单号集合
     * @return 物流信息表数据
     */
    @PostMapping("/queryByCspNos")
    @ApiOperation(value = "根据CSP单号批量查询物流信息", notes = "根据CSP单号批量查询物流信息")
    RestResponse<List<CsLogisticsInfoRespDto>> queryByCspNos(@RequestBody List<String> cspNoList);


    /**
     * 物流信息表分页数据
     *
     * @param filter   物流信息表查询条件
     * @param pageNum  当前页
     * @param pageSize 页大小
     * @return 物流信息表分页数据
     */
    @GetMapping("/page")
    @ApiOperation(value = "物流信息表分页数据", notes = "根据filter查询条件查询物流信息表数据，filter=CsLogisticsInfoReqDto")
    RestResponse<PageInfo<CsLogisticsInfoRespDto>> queryByPage(@RequestParam("filter") String filter,
                                                               @RequestParam(name = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                               @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize);

}
