package com.dtyunxi.yundt.cube.center.inventory.api.cs.inventory;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsPhysicsInventoryBalanceReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

/**
 * 物理仓库存结存表服务接口
 *
 * @author 宁毅
 * @since 2022-04-26
 */
@Api(tags = {"物理仓库存结存表服务"})
@FeignClient(
        contextId = "com-dtyunxi-yundt-cube-center-inventory-api-ICsPhysicsInventoryBalanceApi",
        name = "${yundt.cube.center.inventory.api.name:yundt-cube-center-inventory}",
        path = "/v1/physics/inventory/balance",
        url = "${yundt.cube.center.inventory.api:}"
)
public interface ICsPhysicsInventoryBalanceApi {

    /**
     * 调度任务同步逻辑仓库存结存
     *
     * @return void
     */
    @PostMapping("/physicsInventoryBalanceSync")
    @ApiOperation(value = "调度任务同步逻辑仓库存结存", notes = "调度任务同步逻辑仓库存结存")
    RestResponse<Void> physicsInventoryBalanceSync();

    /**
     * 新增物理仓库存结存表
     *
     * @param addReqDto 物理仓库存结存表请求对象
     * @return 处理结果
     */
    @PostMapping("")
    @ApiOperation(value = "新增物理仓库存结存表", notes = "新增物理仓库存结存表")
    RestResponse<Long> addCsPhysicsInventoryBalance(@RequestBody CsPhysicsInventoryBalanceReqDto addReqDto);

    /**
     * 修改物理仓库存结存表
     *
     * @param modifyReqDto 物理仓库存结存表请求对象
     * @return 处理结果
     */
    @PutMapping("")
    @ApiOperation(value = "修改物理仓库存结存表", notes = "修改物理仓库存结存表")
    RestResponse<Void> modifyCsPhysicsInventoryBalance(@RequestBody CsPhysicsInventoryBalanceReqDto modifyReqDto);

    /**
     * 删除物理仓库存结存表
     *
     * @param ids        物理仓库存结存表删除数据ID
     * @param instanceId 实例ID
     * @return 处理结果
     */
    @DeleteMapping("/{ids}")
    @ApiOperation(value = "删除物理仓库存结存表", notes = "删除物理仓库存结存表")
    RestResponse<Void> removeCsPhysicsInventoryBalance(@PathVariable("ids") String ids, @RequestParam("instanceId") Long instanceId);
}
