/**
 * @(#)CsChannelInventoryApi.java 1.0 2022/03/07 14:51
 * <p>
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.inventory.api.cs.inventory;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsInventoryOperateReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
* 库存中心-物理仓库存对外暴露操作相关接口
*
* @author jingran
* @Date: 2022/03/07 14:51
* @since 1.0.0
*/
@Api(tags = {"库存中心-逻辑仓库存对外暴露操作相关接口"})
@FeignClient(name = "${yundt.cube.center.inventory.api.name: yundt-cube-center-inventory}", path = "/v2/csPhysicsInventoryExposed", url = "${yundt.cube.center.inventory.api:}")
public interface ICsPhysicsInventoryExposedApi {

    /**
     * 库存预占
     * 注意：此接口只会做预占操作，仅仅做库存预占这件事，不会有单据生成或者变动
     *
     * @param inventoryOperateReqDto
     * @return
     */
    @PostMapping(value = "/preemptInventory", produces = "application/json")
    @ApiOperation(value = "库存预占", notes = "库存预占")
    RestResponse<Boolean> preemptInventory(@Validated @RequestBody CsInventoryOperateReqDto inventoryOperateReqDto);

    /**
     * 物理仓库存预占，包含单据操作-生成出库通知单
     *
     * @param inventoryOperateReqDto
     * @return
     */
    @PostMapping(value = "/preemptOrderInventory", produces = "application/json")
    @ApiOperation(value = "物理仓库存预占，包含单据操作-生成出库通知单", notes = "物理仓库存预占，包含单据操作-生成出库通知单")
    RestResponse<Boolean> preemptOrderInventory(@Validated @RequestBody CsInventoryOperateReqDto inventoryOperateReqDto);


    /**
     * 根据订单号取消订单
     * 释放预占的渠道仓、逻辑仓、物理仓库存信息，将发货通知单、出库通知单置为取消状态
     *
     * @param orderNo
     * @return
     */
    @PostMapping(value = "/{orderNo}/releaseInventory", produces = "application/json")
    @ApiOperation(value = "根据订单号取消订单，释放预占的渠道仓、逻辑仓、物理仓库存信息，将发货通知单、出库通知单置为取消状态", notes = "根据订单号取消订单，释放预占的渠道仓、逻辑仓、物理仓库存信息，将发货通知单、出库通知单置为取消状态")
    RestResponse<Boolean> cancelOrder(@PathVariable("orderNo") String orderNo);


    /**
     * 库存释放
     * 仅仅做库存的释放操作
     *
     * @param inventoryOperateReqDto
     * @return
     */
    @PostMapping(value = "/releaseInventory", produces = "application/json")
    @ApiOperation(value = "库存释放", notes = "库存释放")
    RestResponse<Boolean> releaseInventory(@Validated @RequestBody CsInventoryOperateReqDto inventoryOperateReqDto);

    /**
     * 根据订单号进行继续发货
     * 预占物理仓库存，生成出库通知单
     *
     * @param orderNo
     * @return
     */
    @GetMapping(value = "/{orderNo}/continueDelivery", produces = "application/json")
    @ApiOperation(value = "根据订单号进行继续发货", notes = "根据订单号进行继续发货")
    RestResponse<Boolean> continueDelivery(@PathVariable("orderNo") String orderNo);
}