package com.dtyunxi.yundt.cube.center.inventory.api.cs.inventory;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsQualityInfoReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;

/**
* LIMS质检数据同步表服务接口
*
* @author 宁毅
* @since 2022-05-26
*/
@Api(tags = {"LIMS质检数据同步表服务"})
@FeignClient(
    contextId = "com-dtyunxi-yundt-cube-center-inventory-api-ICsQualityInfoApi",
    name = "${yundt.cube.center.inventory.api.name:yundt-cube-center-inventory}",
    path = "/v1/quality/info",
    url = "${yundt.cube.center.inventory.api:}"
)
public interface ICsQualityInfoApi {

/**
* 新增LIMS质检数据同步表
*
* @param addReqDto LIMS质检数据同步表请求对象
* @return 处理结果
*/
@PostMapping("")
@ApiOperation(value = "新增LIMS质检数据同步表", notes = "新增LIMS质检数据同步表")
RestResponse<Long> addCsQualityInfo(@RequestBody CsQualityInfoReqDto addReqDto);

    /**
    * 修改LIMS质检数据同步表
    *
    * @param modifyReqDto LIMS质检数据同步表请求对象
    * @return 处理结果
    */
    @PutMapping("")
    @ApiOperation(value = "修改LIMS质检数据同步表", notes = "修改LIMS质检数据同步表")
    RestResponse<Void> modifyCsQualityInfo(@RequestBody CsQualityInfoReqDto modifyReqDto);

    /**
    * 删除LIMS质检数据同步表
    *
    * @param ids        LIMS质检数据同步表删除数据ID
    * @param instanceId 实例ID
    * @return 处理结果
    */
    @DeleteMapping("/{ids}")
    @ApiOperation(value = "删除LIMS质检数据同步表", notes = "删除LIMS质检数据同步表")
    RestResponse<Void> removeCsQualityInfo(@PathVariable("ids") String ids,@RequestParam("instanceId") Long instanceId);
}
