package com.dtyunxi.yundt.cube.center.inventory.api.cs.inventory;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsQualityInfoDetailReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsReleaseQualityInfoDetailReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 质检转合格服务接口
 *
 * @author 宁毅
 * @since 2022-05-26
 */
@Api(tags = {"质检转合格服务"})
@FeignClient(
        contextId = "com-dtyunxi-yundt-cube-center-inventory-api-ICsQualityInfoDetailApi",
        name = "${yundt.cube.center.inventory.api.name:yundt-cube-center-inventory}",
        path = "/v1/quality/info/detail",
        url = "${yundt.cube.center.inventory.api:}"
)
public interface ICsQualityInfoDetailApi {

    /**
     * 新增质检转合格
     *
     * @param addReqDto 质检转合格请求对象
     * @return 处理结果
     */
    @PostMapping("/addCsQualityInfoDetail")
    @ApiOperation(value = "新增质检转合格", notes = "新增质检转合格")
    RestResponse<Long> addCsQualityInfoDetail(@RequestBody CsQualityInfoDetailReqDto addReqDto);

    /**
     * 批量新增质检转合格
     *
     * @param csQualityInfoDetailReqDtoList 质检转合格集合
     * @return 处理结果
     */
    @PostMapping("/batchAddQualityDetail")
    @ApiOperation(value = "批量新增质检转合格", notes = "批量新增质检转合格")
    RestResponse<Void> batchAddQualityDetail(@RequestBody List<CsQualityInfoDetailReqDto> csQualityInfoDetailReqDtoList);

    /**
     * 修改质检转合格
     *
     * @param modifyReqDto 质检转合格请求对象
     * @return 处理结果
     */
    @PostMapping("/modifyCsQualityInfoDetail")
    @ApiOperation(value = "修改质检转合格", notes = "修改质检转合格")
    RestResponse<Void> modifyCsQualityInfoDetail(@RequestBody CsQualityInfoDetailReqDto modifyReqDto);

    /**
     * 删除质检转合格
     *
     * @param ids        质检转合格删除数据ID
     * @param instanceId 实例ID
     * @return 处理结果
     */
    @DeleteMapping("/{ids}")
    @ApiOperation(value = "删除质检转合格", notes = "删除质检转合格")
    RestResponse<Void> removeCsQualityInfoDetail(@PathVariable("ids") String ids, @RequestParam("instanceId") Long instanceId);


    /**
     * 质检转合格放行
     *
     * @param releaseQualityInfoDetailReqDto 放行参数
     * @return 处理结果
     */
    @PostMapping("/releaseQualityInfoDetail")
    @ApiOperation(value = "质检转合格放行", notes = "质检转合格放行")
    RestResponse<Void> releaseQualityInfoDetail(@RequestBody CsReleaseQualityInfoDetailReqDto releaseQualityInfoDetailReqDto);

    /**
     * 质检转合格批量放行
     *
     * @param releaseQualityInfoDetailReqDtoList 放行参数
     * @return 处理结果
     */
    @PostMapping("/batchRelease")
    @ApiOperation(value = "质检转合格批量放行", notes = "质检转合格批量放行")
    RestResponse<Void> batchRelease(@RequestBody List<CsReleaseQualityInfoDetailReqDto> releaseQualityInfoDetailReqDtoList);

}
