package com.dtyunxi.yundt.cube.center.inventory.api.cs.inventory;


import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsDeliveryNumDetailsQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsQualityInfoDetailQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.inventory.CsDeliveryNumDetailsRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.inventory.CsQualityInfoDetailRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.inventory.CsQueryWarehouseRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.inventory.CsWarehouseDetailsRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 质检转合格服务接口
 *
 * @author 宁毅
 * @since 2022-05-26
 */
@Api(tags = {"质检转合格服务"})
@FeignClient(
        contextId = "com-dtyunxi-yundt-cube-center-inventory-api-query-ICsQualityInfoDetailQueryApi",
        name = "${yundt.cube.center.inventory.api.name:yundt-cube-center-inventory}",
        path = "/v1/quality/info/detail",
        url = "${yundt.cube.center.inventory.api:}"
)
public interface ICsQualityInfoDetailQueryApi {

    /**
     * 根据id查询质检转合格
     *
     * @param id 质检转合格id
     * @return 质检转合格数据
     */
    @GetMapping("/{id}")
    @ApiOperation(value = "根据id查询质检转合格", notes = "根据id查询质检转合格")
    RestResponse<CsQualityInfoDetailRespDto> queryById(@PathVariable("id") Long id);

    /**
     * 质检转合格分页数据
     *
     * @param qualityInfoDetailQueryDto 质检转合格查询条件
     * @return 质检转合格分页数据
     */
    @PostMapping("/page")
    @ApiOperation(value = "质检转合格分页数据", notes = "质检转合格分页数据")
    RestResponse<PageInfo<CsQualityInfoDetailRespDto>> queryByPage(@RequestBody CsQualityInfoDetailQueryDto qualityInfoDetailQueryDto);

    /**
     * 获取出库数量详情
     *
     * @param deliveryNumDetailsQueryDto 获取出库数量详情
     * @return 质检转合格分页数据
     */
    @PostMapping("/getDeliveryNumDetails")
    @ApiOperation(value = "获取出库数量详情", notes = "获取出库数量详情")
    RestResponse<PageInfo<CsDeliveryNumDetailsRespDto>> getDeliveryNumDetails(@RequestBody CsDeliveryNumDetailsQueryDto deliveryNumDetailsQueryDto);

    /**
     * 查看仓库
     *
     * @param deliveryNumDetailsQueryDto 查看仓库
     * @return 查看仓库
     */
    @PostMapping("/getWarehouse")
    @ApiOperation(value = "查看仓库", notes = "查看仓库")
    RestResponse<PageInfo<CsWarehouseDetailsRespDto>> getWarehouse(@RequestBody CsDeliveryNumDetailsQueryDto deliveryNumDetailsQueryDto);


    /**
     * 不合格仓库放行仓库详情（可选择不合格仓库和待处理仓库）
     *
     * @param orderNo 待检转合格单号
     * @return 仓库信息
     */
    @GetMapping("/queryReleaseWarehouse")
    @ApiOperation(value = "不合格仓库放行仓库详情（可选择不合格仓库和待处理仓库）", notes = "不合格仓库放行仓库详情（可选择不合格仓库和待处理仓库）")
    RestResponse<List<CsQueryWarehouseRespDto>> queryReleaseWarehouse(@RequestParam("orderNo") String orderNo);


}
