package com.dtyunxi.yundt.cube.center.inventory.api.cs.inventory;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.inventory.CsQualityInfoRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.GetMapping;
import com.github.pagehelper.PageInfo;

/**
* LIMS质检数据同步表服务接口
*
* @author 宁毅
* @since 2022-05-26
*/
@Api(tags = {"LIMS质检数据同步表服务"})
@FeignClient(
    contextId = "com-dtyunxi-yundt-cube-center-inventory-api-query-ICsQualityInfoQueryApi",
    name = "${yundt.cube.center.inventory.api.name:yundt-cube-center-inventory}",
    path = "/v1/quality/info",
    url = "${yundt.cube.center.inventory.api:}"
)
public interface ICsQualityInfoQueryApi {

    /**
    * 根据id查询LIMS质检数据同步表
    *
    * @param id LIMS质检数据同步表id
    * @return   LIMS质检数据同步表数据
    */
    @GetMapping("/{id}")
    @ApiOperation(value = "根据id查询LIMS质检数据同步表", notes = "根据id查询LIMS质检数据同步表")
    RestResponse<CsQualityInfoRespDto> queryById(@PathVariable("id") Long id);

    /**
    * LIMS质检数据同步表分页数据
    *
    * @param filter   LIMS质检数据同步表查询条件
    * @param pageNum  当前页
    * @param pageSize 页大小
    * @return LIMS质检数据同步表分页数据
    */
    @GetMapping("/page")
    @ApiOperation(value = "LIMS质检数据同步表分页数据", notes = "根据filter查询条件查询LIMS质检数据同步表数据，filter=CsQualityInfoReqDto")
    RestResponse<PageInfo<CsQualityInfoRespDto>> queryByPage(@RequestParam("filter") String filter,
                                                           @RequestParam(name = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                           @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize);

}
