package com.dtyunxi.yundt.cube.center.inventory.api.cs.inventory.external;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsInventoryOperateReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsInventoryPageQueryReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.inventory.CsInventoryPageQueryRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.inventory.CsInventoryPreemptionRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * 对外暴露给第三方使用的库存操作接口
 *
 * @author jingran
 * @version 1.0
 * @Date 2022/1/14 1:47 下午
 */
@Api(tags = {"库存中心-对外暴露给第三方使用的库存操作接口"})
@FeignClient(name = "${yundt.cube.center.inventory.api.name: yundt-cube-center-inventory}", path = "/v2/csInventoryExposedExternal", url = "${yundt.cube.center.inventory.api:}")
public interface ICsInventoryExposedExternalApi {

    /**
     * 库存预占
     * 注意：此接口只会做预占操作，仅仅做库存预占这件事，不会有单据生成或者变动
     *
     * @param inventoryOperateReqDto
     * @return
     */
    @PostMapping(value = "/preemptInventory", produces = "application/json")
    @ApiOperation(value = "库存预占", notes = "库存预占")
    RestResponse<Boolean> preemptInventory(@Validated @RequestBody CsInventoryOperateReqDto inventoryOperateReqDto);

}
