package com.dtyunxi.yundt.cube.center.inventory.api.cs.inventory.external;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.basics.CsInventoryBasicsQueryReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsInventoryBatchQueryReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsInventoryPageQueryReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsInventoryWarehouseQueryReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.log.CsActivityInventoryLogPageQueryReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.log.CsInventoryLogPageQueryReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.basics.CsInventoryBasicsQueryRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.inventory.CsInventoryBatchQueryRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.inventory.CsInventoryPageQueryRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.inventory.CsInventoryPreemptionRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.inventory.CsInventoryWarehouseQueryRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.log.CsActivityInventoryLogPageQueryRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.log.CsInventoryLogPageQueryRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * 对外暴露给第三方使用的库存查询接口
 *
 * @author jingran
 * @version 1.0
 * @Date 2022/1/14 1:47 下午
 */
@Api(tags = {"库存中心-对外暴露给第三方使用的库存查询接口"})
@FeignClient(name = "${yundt.cube.center.inventory.api.name: yundt-cube-center-inventory}", path = "/v2/csInventoryExposedExternalQuery", url = "${yundt.cube.center.inventory.api:}")
public interface ICsInventoryExposedExternalQueryApi {

    /**
     * 库存分页查询
     *
     * @param csInventoryPageQueryReqDto
     * @return
     */
    @PostMapping(value = "/queryInventoryPage", produces = "application/json")
    @ApiOperation(value = "库存分页查询", notes = "库存分页查询")
    RestResponse<PageInfo<CsInventoryPageQueryRespDto>> queryInventoryPage(@Validated @RequestBody CsInventoryPageQueryReqDto csInventoryPageQueryReqDto);

    /**
     * 查询库存预占信息
     *
     * @param csInventoryPageQueryReqDto
     * @return
     */
    @PostMapping(value = "/queryPreemptionPage", produces = "application/json")
    @ApiOperation(value = "查询库存预占信息", notes = "查询库存预占信息")
    RestResponse<PageInfo<CsInventoryPreemptionRespDto>> queryPreemptionPage(@Validated @RequestBody CsInventoryPageQueryReqDto csInventoryPageQueryReqDto);

}
