/**
 * @(#)CsChannelInventoryApi.java 1.0 2022/03/07 14:51
 * <p>
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.inventory.api.cs.inventory.pcp;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsChannelInventoryAddReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsChannelInventoryUpdateReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsInventoryOperateReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsInventoryReleasePreemptOperateReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
* 库存中心-渠道仓库存对外暴露操作相关接口
*
* @author jingran
* @Date: 2022/03/07 14:51
* @since 1.0.0
*/
@Api(tags = {"库存中心-渠道仓库存对外暴露操作相关接口"})
@FeignClient(name = "${yundt.cube.center.inventory.api.name: yundt-cube-center-inventory}", path = "/v2/csChannelInventoryExposed", url = "${yundt.cube.center.inventory.api:}")
public interface ICsChannelInventoryExposedApi {

    /**
     * 库存预占
     * 注意：此接口只会做预占操作，仅仅做库存预占这件事，不会有单据生成或者变动
     *
     * @param inventoryOperateReqDto
     * @return
     */
    @PostMapping(value = "/preemptInventory", produces = "application/json")
    @ApiOperation(value = "库存预占", notes = "库存预占")
    RestResponse<Boolean> preemptInventory(@Validated @RequestBody CsInventoryOperateReqDto inventoryOperateReqDto);

    /**
     * 库存释放
     *
     * @param inventoryOperateReqDto
     * @return
     */
    @PostMapping(value = "/releaseInventory", produces = "application/json")
    @ApiOperation(value = "库存释放", notes = "库存释放")
    RestResponse<Boolean> releaseInventory(@Validated @RequestBody CsInventoryOperateReqDto inventoryOperateReqDto);

    /**
     * 库存释放，根据订单号找到预占记录进行释放
     *
     * @param releasePreemptOperateReqDto
     * @return
     */
    @PostMapping(value = "/releaseInventoryByPreemption", produces = "application/json")
    @ApiOperation(value = "库存释放，根据订单号找到预占记录进行释放", notes = "库存释放，根据订单号找到预占记录进行释放")
    RestResponse<Boolean> releaseInventoryByPreemption(@Validated @RequestBody CsInventoryReleasePreemptOperateReqDto releasePreemptOperateReqDto);

    /**
     * 库存释放，响应编码
     * 注意：不抛出异常，预占记录不存在，返回对应的编码
     * com.dtyunxi.yundt.cube.center.inventory.enums.CsInventoryReleaseResultEnum
     *
     * @param releasePreemptOperateReqDto
     * @return
     */
    @PostMapping(value = "/releaseInventoryByPreemptionCode", produces = "application/json")
    @ApiOperation(value = "库存释放，响应编码", notes = "库存释放，根据订单号找到预占记录进行释放")
    RestResponse<String> releaseInventoryByPreemptionCode(@Validated @RequestBody CsInventoryReleasePreemptOperateReqDto releasePreemptOperateReqDto);


}