/**
 * @(#)CsLockLogQueryApi.java 1.0 2022/05/30 15:49
 * <p>
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.inventory.api.cs.inventory.pcp;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsLockLogQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.inventory.CsLockLogRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * CsLockLogQueryApi
 *
 * @author wenyi
 * @Date: 2022/05/30 15:49
 * @since 1.0.0
 */
@Api(tags = {"CsLockLog接口"})
@FeignClient(name = "${yundt.cube.center.inventory.api.name: yundt-cube-center-inventory}", path = "/v1/csLockLog", url = "${yundt.cube.center.inventory.api:}")
public interface ICsLockLogQueryApi {

    /**
     * 分页查询
     *
     * @param queryDto
     * @return
     */
    @Deprecated
    @PostMapping(value = "/page", produces = "application/json")
    @ApiOperation(value = "分页查询 请调用报表中心api", notes = "分页查询 请调用报表中心api")
    RestResponse<PageInfo<CsLockLogRespDto>> queryByPage(@Validated @RequestBody CsLockLogQueryDto queryDto);

}