/**
 * @(#)CsLockOrderApi.java 1.0 2022/05/30 15:48
 * <p>
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.inventory.api.cs.inventory.pcp;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsLockOrderUpdateReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;
import java.util.Map;

/**
 * CsLockOrderApi
 *
 * @author wenyi
 * @Date: 2022/05/30 15:48
 * @since 1.0.0
 */
@Api(tags = {"CsLockOrder接口"})
@FeignClient(name = "${yundt.cube.center.inventory.api.name: yundt-cube-center-inventory}", path = "/v1/csLockOrder", url = "${yundt.cube.center.inventory.api:}")
public interface ICsLockOrderApi {

    /**
     * 根据类型更新锁定库存
     *
     * @param type         lock 锁库，unlock 解锁
     * @param updateReqDto 更新商品信息
     * @return
     */
    @PostMapping(value = "/update/{type}/lockInventory", produces = "application/json")
    @ApiOperation(value = " 根据类型（lock 锁库，unlock 解锁）更新锁定库存", notes = " 根据类型（lock 锁库，unlock 解锁）更新锁定库存")
    RestResponse<Void> updateLockInventory(@PathVariable(name = "type") String type, @RequestBody CsLockOrderUpdateReqDto updateReqDto);

    /**
     * 批量根据类型更新锁定库存
     *
     * @param type   lock 锁库，unlock 解锁
     * @param list   更新商品信息集合
     * @return
     */
    @PostMapping(value = "/batch/update/{type}/lockInventory", produces = "application/json")
    @ApiOperation(value = "批量根据类型更新锁定库存", notes = "批量根据类型更新锁定库存")
    RestResponse<Map<String, Integer>> batchUpdateLockInventory(@PathVariable(name = "type") String type, @RequestBody List<CsLockOrderUpdateReqDto> list);

    /**
     * 手动将临期的锁库信息解锁
     */
    @PostMapping(value = "/manual/unLockInventory", produces = "application/json")
    @ApiOperation(value = "手动将临期的锁库信息解锁", notes = "手动将临期的锁库信息解锁")
    RestResponse<Void> manualUnLockInventory();

}